/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.tools.idea.designer.AndroidVariationPaletteItem;
import com.android.tools.idea.designer.FillPolicy;
import com.android.tools.idea.designer.ResizePolicy;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import org.jdom.Element;

public class AndroidMetaModel
extends MetaModel {
    static final String ATTR_RESIZE = "resize";
    static final String ATTR_FILL = "fill";
    private ResizePolicy myResizePolicy;
    private FillPolicy myFillPolicy;

    public AndroidMetaModel(Class<RadComponent> model, String target, String tag) {
        super(model, target, tag);
    }

    public void initializeFrom(Element element) {
        FillPolicy fillPolicy;
        String fill;
        ResizePolicy resizePolicy;
        String resize = element.getAttributeValue(ATTR_RESIZE);
        if (resize != null && (resizePolicy = ResizePolicy.get(resize)) != null) {
            this.myResizePolicy = resizePolicy;
        }
        if ((fill = element.getAttributeValue(ATTR_FILL)) != null && (fillPolicy = FillPolicy.get(fill)) != null) {
            this.myFillPolicy = fillPolicy;
        }
    }

    public ResizePolicy getResizePolicy() {
        AndroidVariationPaletteItem item;
        ResizePolicy policy;
        PaletteItem paletteItem = this.getPaletteItem();
        if (paletteItem instanceof AndroidVariationPaletteItem && (policy = (item = (AndroidVariationPaletteItem)paletteItem).getResizePolicy()) != null) {
            return policy;
        }
        return this.myResizePolicy != null ? this.myResizePolicy : ResizePolicy.full();
    }

    public FillPolicy getFillPolicy() {
        AndroidVariationPaletteItem item;
        FillPolicy fill;
        PaletteItem paletteItem = this.getPaletteItem();
        if (paletteItem instanceof AndroidVariationPaletteItem && (fill = (item = (AndroidVariationPaletteItem)paletteItem).getFillPolicy()) != null) {
            return fill;
        }
        return this.myFillPolicy != null ? this.myFillPolicy : FillPolicy.NONE;
    }
}

