/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ThemeSelectionDialog
extends DialogWrapper {
    private final ThemeSelectionPanel myPanel;

    public ThemeSelectionDialog(Configuration configuration) {
        this(configuration, Collections.emptySet());
    }

    public ThemeSelectionDialog(Configuration configuration, Set<String> excludedThemes) {
        super(configuration.getModule().getProject());
        this.myPanel = new ThemeSelectionPanel(this, configuration, excludedThemes);
        this.setTitle("Select Theme");
        this.init();
    }

    public void setThemeChangedListener(ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        this.myPanel.setThemeChangedListener(themeChangedListener);
    }

    protected JComponent createCenterPanel() {
        JPanel contentPanel = this.myPanel.getContentPanel();
        contentPanel.setPreferredSize((Dimension)JBUI.size((int)800, (int)500));
        return contentPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidThemeDialog";
    }

    public String getTheme() {
        return this.myPanel.getTheme();
    }

    public void checkValidation() {
        this.initValidation();
    }

    protected ValidationInfo doValidate() {
        String theme = this.myPanel.getTheme();
        if (theme == null) {
            return new ValidationInfo("Select a theme");
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }
}

