/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.FlatAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;

public class ThemeMenuAction
extends FlatAction {
    private final RenderContext myRenderContext;

    public ThemeMenuAction(RenderContext renderContext) {
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Theme to render layout with");
        presentation.setIcon(RenderService.NELE_ENABLED ? AndroidIcons.NeleIcons.Theme : AndroidIcons.Themes);
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            String brief = ThemeMenuAction.getThemeLabel(configuration.getTheme(), true);
            presentation.setText(brief, false);
            presentation.setDescription(ThemeMenuAction.getThemeLabel(configuration.getTheme(), false));
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public static String getThemeLabel(String theme, boolean brief) {
        int index;
        if (theme == null) {
            return "";
        }
        theme = ResourceHelper.styleToTheme(theme);
        if (brief && (index = theme.lastIndexOf(46)) < theme.length() - 1) {
            return theme.substring(index + 1);
        }
        return theme;
    }

    public void actionPerformed(AnActionEvent e) {
        String theme;
        ThemeSelectionDialog dialog;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (dialog = new ThemeSelectionDialog(configuration)).showAndGet() && (theme = dialog.getTheme()) != null) {
            configuration.setTheme(theme);
            this.myRenderContext.requestRender();
        }
    }
}

