/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.android.designer.AndroidDesignerEditor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowManager;

abstract class ConfigurationAction
extends AnAction
implements ConfigurationListener {
    private static final String FILE_ARROW = " \u2192 ";
    protected final RenderContext myRenderContext;
    private int myFlags;

    public ConfigurationAction(RenderContext renderContext, String title) {
        this(renderContext, title, null);
    }

    public ConfigurationAction(RenderContext renderContext, String title, Icon icon) {
        super(title, null, icon);
        this.myRenderContext = renderContext;
    }

    protected void updatePresentation() {
    }

    public void actionPerformed(AnActionEvent e) {
        this.tryUpdateConfiguration();
        this.updatePresentation();
        this.myRenderContext.requestRender();
    }

    protected void tryUpdateConfiguration() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            ConfigurationMatcher matcher;
            List<VirtualFile> matchingFiles;
            VirtualFile file;
            Module module;
            boolean affectsFileSelection;
            Configuration clone = configuration.clone();
            this.myFlags = 0;
            clone.addListener(this);
            this.updateConfiguration(clone, false);
            clone.removeListener(this);
            boolean bl = affectsFileSelection = (this.myFlags & 0xF6) != 0;
            if (affectsFileSelection && (module = this.myRenderContext.getModule()) != null && (file = this.myRenderContext.getVirtualFile()) != null && !(matchingFiles = (matcher = new ConfigurationMatcher(clone, AppResourceRepository.getAppResources(module, true), file)).getBestFileMatches()).isEmpty() && !matchingFiles.contains(file)) {
                this.pickedBetterMatch(matchingFiles.get(0), file);
                AndroidFacet facet = AndroidFacet.getInstance(module);
                assert (facet != null);
                this.updateConfiguration(facet.getConfigurationManager().getConfiguration(matchingFiles.get(0)), true);
                return;
            }
            this.updateConfiguration(configuration, true);
        }
    }

    protected void pickedBetterMatch(VirtualFile file, VirtualFile old) {
        Module module = this.myRenderContext.getModule();
        assert (module != null);
        Project project = module.getProject();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, -1);
        FileEditorManager manager = FileEditorManager.getInstance((Project)project);
        FileEditor selectedEditor = manager.getSelectedEditor(old);
        List editors = manager.openEditor(descriptor, true);
        if (selectedEditor instanceof AndroidDesignerEditor) {
            manager.setSelectedEditor(file, "android-designer");
        } else if (selectedEditor != null) {
            manager.setSelectedEditor(file, TextEditorProvider.getInstance().getEditorTypeId());
            if (!editors.isEmpty()) {
                for (FileEditor editor : editors) {
                    if (!(editor instanceof TextEditor) || !editor.getComponent().isShowing()) continue;
                    AndroidLayoutPreviewToolWindowManager previewManager = AndroidLayoutPreviewToolWindowManager.getInstance(project);
                    previewManager.notifyFileShown((TextEditor)editor, true);
                    if (RenderService.NELE_ENABLED) break;
                }
            }
        }
    }

    @Override
    public boolean changed(int flags) {
        this.myFlags |= flags;
        return true;
    }

    protected abstract void updateConfiguration(Configuration var1, boolean var2);

    public static boolean isBetterMatchLabel(String label) {
        return label.contains(FILE_ARROW);
    }

    public static String getBetterMatchLabel(String prefix, VirtualFile better, VirtualFile file) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(FILE_ARROW);
        String folderName = better.getParent().getName();
        if (folderName.equals("layout")) {
            if (file != null && !Comparing.equal((Object)file.getParent(), (Object)better.getParent())) {
                sb.append("layout");
                sb.append(File.separatorChar);
            }
        } else {
            if (folderName.startsWith("layout")) {
                folderName = folderName.substring("layout".length() + 1);
            }
            sb.append(folderName);
            sb.append(File.separatorChar);
        }
        sb.append(better.getName());
        return sb.toString();
    }

    public static Icon getBetterMatchIcon() {
        return AndroidIcons.NotMatch;
    }
}

