/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.HaxmAlert;
import com.android.tools.idea.avdmanager.HaxmWizard;
import com.android.tools.idea.welcome.install.Haxm;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class RunAvdAction
extends AvdUiAction {
    public RunAvdAction(AvdUiAction.AvdInfoProvider provider) {
        super(provider, "Run", "Launch this AVD in the emulator", AllIcons.Actions.Execute);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AvdInfo avdInfo = this.getAvdInfo();
        if (avdInfo != null && this.checkReady()) {
            AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(this.myAvdInfoProvider.getProject(), avdInfo);
        }
    }

    @Override
    public boolean isEnabled() {
        AvdInfo avdInfo = this.getAvdInfo();
        return avdInfo != null && avdInfo.getStatus() == AvdInfo.AvdStatus.OK;
    }

    private boolean checkReady() {
        if (Haxm.canRun() && this.myAvdInfoProvider.getAvdInfo().getAbiType().contains("x86") && HaxmAlert.getHaxmState(true) == HaxmAlert.HaxmState.NOT_INSTALLED) {
            int result = Messages.showOkCancelDialog((Component)this.myAvdInfoProvider.getComponent(), (String)"Intel HAXM is not installed, and is required to run this AVD.\nWould you like to install it now?", (String)"Install HAXM", (Icon)AllIcons.General.WarningDialog);
            if (result == 0) {
                HaxmWizard wizard = new HaxmWizard();
                wizard.init();
                return wizard.showAndGet();
            }
            return false;
        }
        return true;
    }
}

