/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.avdmanager.ConfigureDeviceOptionsStep;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.SingleStepDialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.SingleStepWizard;
import com.intellij.openapi.ui.DialogWrapper;

public class DeviceEditWizard
extends SingleStepWizard {
    public DeviceEditWizard(Device deviceTemplate, boolean forceCreation) {
        super(null, null, new ConfigureDeviceOptionsStep(deviceTemplate, forceCreation, null), (DynamicWizardHost)new SingleStepDialogWrapperHost(null, DialogWrapper.IdeModalityType.PROJECT));
        this.setTitle("Hardware Profile Configuration");
    }

    @Override
    public void performFinishingActions() {
        Device device = this.getState().get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
        if (device != null) {
            DeviceManagerConnection.getDefaultDeviceManagerConnection().createOrEditDevice(device);
        }
    }

    @Override
    protected String getProgressTitle() {
        return "Creating/Updating device...";
    }

    public Device getEditedDevice() {
        return this.getState().get(AvdWizardConstants.DEVICE_DEFINITION_KEY);
    }

    @Override
    protected String getWizardActionDescription() {
        return "Create or edit a virtual device hardware profile";
    }
}

