/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.CloneDeviceAction;
import com.android.tools.idea.avdmanager.CreateDeviceAction;
import com.android.tools.idea.avdmanager.DeleteDeviceAction;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.DeviceUiAction;
import com.android.tools.idea.avdmanager.EditDeviceAction;
import com.android.tools.idea.avdmanager.ExportDeviceAction;
import com.android.tools.idea.avdmanager.ImportDevicesAction;
import com.android.tools.idea.npw.FormFactorUtils;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class DeviceDefinitionList
extends JPanel
implements ListSelectionListener,
DocumentListener,
DeviceUiAction.DeviceProvider {
    private static final double PHONE_SIZE_CUTOFF = 6.0;
    private static final double TV_SIZE_CUTOFF = 15.0;
    private static final String SEARCH_RESULTS = "Search Results";
    private static final String PHONE_TYPE = "Phone";
    private static final String TABLET_TYPE = "Tablet";
    private static final String OTHER_TYPE = "Other";
    private static final String DEFAULT_PHONE = "Nexus 5";
    private static final String DEFAULT_TABLET = "Nexus 10";
    private static final String DEFAULT_WEAR = "Android Wear Square";
    private static final String DEFAULT_TV = "Android TV (1080p)";
    private Map<String, List<Device>> myDeviceCategoryMap;
    private static final Map<String, Device> myDefaultCategoryDeviceMap = Maps.newHashMap();
    private static final DecimalFormat ourDecimalFormat = new DecimalFormat(".##");
    private final ListTableModel<Device> myModel;
    private TableView<Device> myTable;
    private final ListTableModel<String> myCategoryModel;
    private TableView<String> myCategoryList;
    private JButton myCreateProfileButton;
    private JButton myImportProfileButton;
    private JButton myRefreshButton;
    private JPanel myPanel;
    private SearchTextField mySearchTextField;
    private List<DeviceDefinitionSelectionListener> myListeners;
    private List<DeviceCategorySelectionListener> myCategoryListeners;
    private List<Device> myDevices;
    private Device myDefaultDevice;
    private final ColumnInfo[] myCategoryInfo;
    private final ColumnInfo[] myColumnInfos;
    private final Border myBorder;
    private final TableCellRenderer myRenderer;

    public DeviceDefinitionList() {
        this.$$$setupUI$$$();
        this.myDeviceCategoryMap = Maps.newHashMap();
        this.myModel = new ListTableModel(new ColumnInfo[0]);
        this.myCategoryModel = new ListTableModel(new ColumnInfo[0]);
        this.myListeners = Lists.newArrayList();
        this.myCategoryListeners = Lists.newArrayList();
        this.myCategoryInfo = new ColumnInfo[]{new ColumnInfo<String, String>("Category"){

            public String valueOf(String category) {
                return category;
            }

            public TableCellRenderer getRenderer(String s) {
                return DeviceDefinitionList.this.myRenderer;
            }
        }};
        this.myColumnInfos = new ColumnInfo[]{new DeviceColumnInfo("Name"){

            public String valueOf(Device device) {
                return device.getDisplayName();
            }

            public String getPreferredStringValue() {
                return "4.65\" 720 (Galaxy Nexus)";
            }

            @Override
            public Comparator<Device> getComparator() {
                return new Comparator<Device>(){

                    @Override
                    public int compare(Device o1, Device o2) {
                        String name2;
                        String name1 = this.valueOf(o1);
                        if (name1 == (name2 = this.valueOf(o2))) {
                            return 0;
                        }
                        if (name1 == null || name2 == null || name1.isEmpty() || name2.isEmpty()) {
                            return name1 == null ? -1 : 1;
                        }
                        char firstChar1 = name1.charAt(0);
                        char firstChar2 = name2.charAt(0);
                        if (Character.isLetter(firstChar1) && !Character.isLetter(firstChar2)) {
                            return 1;
                        }
                        if (Character.isLetter(firstChar2) && !Character.isLetter(firstChar1)) {
                            return -1;
                        }
                        return name1.compareTo(name2);
                    }
                };
            }
        }, new DeviceColumnInfo("Size"){

            public String valueOf(Device device) {
                return DeviceDefinitionList.getDiagonalSize(device);
            }

            @Override
            public Comparator<Device> getComparator() {
                return new Comparator<Device>(){

                    @Override
                    public int compare(Device o1, Device o2) {
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return Double.valueOf(o1.getDefaultHardware().getScreen().getDiagonalLength()).compareTo(o2.getDefaultHardware().getScreen().getDiagonalLength());
                    }
                };
            }
        }, new DeviceColumnInfo("Resolution"){

            public String valueOf(Device device) {
                return DeviceDefinitionList.getDimensionString(device);
            }

            @Override
            public Comparator<Device> getComparator() {
                return new Comparator<Device>(){

                    @Override
                    public int compare(Device o1, Device o2) {
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        Dimension d1 = o1.getScreenSize(o1.getDefaultState().getOrientation());
                        Dimension d2 = o2.getScreenSize(o2.getDefaultState().getOrientation());
                        if (d1 == null) {
                            return -1;
                        }
                        if (d2 == null) {
                            return 1;
                        }
                        return Integer.valueOf(d1.width * d1.height).compareTo(d2.width * d2.height);
                    }
                };
            }
        }, new DeviceColumnInfo("Density"){

            public String valueOf(Device device) {
                return DeviceDefinitionList.getDensityString(device);
            }
        }};
        this.myBorder = IdeBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10);
        this.myRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JBLabel label = new JBLabel((String)value);
                label.setBorder(DeviceDefinitionList.this.myBorder);
                if (table.getSelectedRow() == row) {
                    label.setBackground(table.getSelectionBackground());
                    label.setForeground(table.getSelectionForeground());
                    label.setOpaque(true);
                }
                return label;
            }
        };
        this.myModel.setColumnInfos(this.myColumnInfos);
        this.myModel.setSortable(true);
        this.refreshDeviceProfiles();
        this.setDefaultDevices();
        this.myTable.setModelAndUpdateColumns(this.myModel);
        this.myTable.getRowSorter().toggleSortOrder(0);
        this.myTable.getRowSorter().toggleSortOrder(0);
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.setLayout(new BorderLayout());
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceDefinitionList.this.refreshDeviceProfiles();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(this);
        this.myCategoryModel.setColumnInfos(this.myCategoryInfo);
        this.myCategoryList.setModelAndUpdateColumns(this.myCategoryModel);
        this.myCategoryList.getSelectionModel().addListSelectionListener(this);
        this.mySearchTextField.addDocumentListener((DocumentListener)this);
        this.add((Component)this.myPanel, "Center");
        this.myCreateProfileButton.setAction(new CreateDeviceAction(this));
        this.myCreateProfileButton.setText("New Hardware Profile");
        this.myImportProfileButton.setAction(new ImportDevicesAction(this));
        this.myImportProfileButton.setText("Import Hardware Profiles");
        this.myTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DeviceDefinitionList.this.possiblyShowPopup(e);
            }
        });
    }

    private void setDefaultDevices() {
        for (Device d : this.myDeviceCategoryMap.get(PHONE_TYPE)) {
            if (!d.getDisplayName().equals(DEFAULT_PHONE)) continue;
            myDefaultCategoryDeviceMap.put(PHONE_TYPE, d);
            this.myDefaultDevice = d;
            break;
        }
        for (Device d : this.myDeviceCategoryMap.get(TABLET_TYPE)) {
            if (!d.getDisplayName().equals(DEFAULT_TABLET)) continue;
            myDefaultCategoryDeviceMap.put(TABLET_TYPE, d);
            break;
        }
        for (Device d : this.myDeviceCategoryMap.get(FormFactorUtils.FormFactor.WEAR.toString())) {
            if (!d.getDisplayName().equals(DEFAULT_WEAR)) continue;
            myDefaultCategoryDeviceMap.put(FormFactorUtils.FormFactor.WEAR.toString(), d);
            break;
        }
        for (Device d : this.myDeviceCategoryMap.get(FormFactorUtils.FormFactor.TV.toString())) {
            if (!d.getDisplayName().equals(DEFAULT_TV)) continue;
            myDefaultCategoryDeviceMap.put(FormFactorUtils.FormFactor.TV.toString(), d);
            break;
        }
    }

    private static JBMenuItem createMenuItem(DeviceUiAction action) {
        JBMenuItem item = new JBMenuItem((Action)action);
        item.setText(action.getText());
        return item;
    }

    private void possiblyShowPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        int row = this.myTable.rowAtPoint(p);
        int col = this.myTable.columnAtPoint(p);
        if (row != -1 && col != -1) {
            JBPopupMenu menu = new JBPopupMenu();
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new CloneDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new EditDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new ExportDeviceAction(this)));
            menu.add((JMenuItem)DeviceDefinitionList.createMenuItem(new DeleteDeviceAction(this)));
            menu.show(this.myTable, p.x, p.y);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.myCategoryList.getSelectionModel())) {
            this.setCategory((String)this.myCategoryList.getSelectedObject());
        } else if (e.getSource().equals(this.myTable.getSelectionModel())) {
            this.onSelectionSet((Device)this.myTable.getSelectedObject());
        }
    }

    public void addSelectionListener(DeviceDefinitionSelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void addCategoryListener(DeviceCategorySelectionListener listener) {
        this.myCategoryListeners.add(listener);
    }

    public void removeSelectionListener(DeviceDefinitionSelectionListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void selectDefaultDevice() {
        this.setSelectedDevice(this.myDefaultDevice);
    }

    public void setSelectedDevice(Device device) {
        if (Objects.equal((Object)device, (Object)this.myTable.getSelectedObject())) {
            return;
        }
        this.onSelectionSet(device);
        if (device != null) {
            String category = DeviceDefinitionList.getCategory(device);
            for (Device listItem : this.myModel.getItems()) {
                if (!listItem.getId().equals(device.getId())) continue;
                this.myTable.setSelection((Collection)ImmutableSet.of((Object)listItem));
            }
            this.myCategoryList.setSelection((Collection)ImmutableSet.of((Object)category));
            this.setCategory(category);
        }
    }

    private void onSelectionSet(Device selectedObject) {
        if (selectedObject != null) {
            myDefaultCategoryDeviceMap.put(DeviceDefinitionList.getCategory(selectedObject), selectedObject);
        }
        for (DeviceDefinitionSelectionListener listener : this.myListeners) {
            listener.onDeviceSelectionChanged(selectedObject);
        }
    }

    public void setCategory(String selectedCategory) {
        if (this.myDeviceCategoryMap.containsKey(selectedCategory)) {
            List<Device> newItems = this.myDeviceCategoryMap.get(selectedCategory);
            if (!((Object)this.myModel.getItems()).equals(newItems)) {
                this.myModel.setItems(newItems);
                this.setSelectedDevice(myDefaultCategoryDeviceMap.get(selectedCategory));
                this.notifyCategoryListeners(selectedCategory, newItems);
            }
        }
    }

    private void notifyCategoryListeners(String selectedCategory, List<Device> items) {
        for (DeviceCategorySelectionListener listener : this.myCategoryListeners) {
            listener.onCategorySelectionChanged(selectedCategory, items);
        }
    }

    private void refreshDeviceProfiles() {
        this.myDevices = DeviceManagerConnection.getDefaultDeviceManagerConnection().getDevices();
        this.myDeviceCategoryMap.clear();
        for (Device d : this.myDevices) {
            String category = DeviceDefinitionList.getCategory(d);
            if (!this.myDeviceCategoryMap.containsKey(category)) {
                this.myDeviceCategoryMap.put(category, new ArrayList(1));
            }
            this.myDeviceCategoryMap.get(category).add(d);
        }
        Set<String> categories = this.myDeviceCategoryMap.keySet();
        Object[] categoryArray = categories.toArray(new String[categories.size()]);
        this.myCategoryModel.setItems((List)Lists.newArrayList((Object[])categoryArray));
    }

    private static String getCategory(Device d) {
        if (HardwareConfigHelper.isTv((Device)d) || DeviceDefinitionList.hasTvSizedScreen(d)) {
            return FormFactorUtils.FormFactor.TV.toString();
        }
        if (HardwareConfigHelper.isWear((Device)d)) {
            return FormFactorUtils.FormFactor.WEAR.toString();
        }
        if (DeviceDefinitionList.isTablet(d)) {
            return TABLET_TYPE;
        }
        if (DeviceDefinitionList.isPhone(d)) {
            return PHONE_TYPE;
        }
        return OTHER_TYPE;
    }

    private static boolean isPhone(Device d) {
        return d.getDefaultHardware().getScreen().getDiagonalLength() < 6.0;
    }

    private static boolean isTablet(Device d) {
        return d.getDefaultHardware().getScreen().getDiagonalLength() >= 6.0;
    }

    private static boolean hasTvSizedScreen(Device d) {
        return d.getDefaultHardware().getScreen().getDiagonalLength() >= 15.0;
    }

    public static String getDiagonalSize(Device device) {
        return ourDecimalFormat.format(device.getDefaultHardware().getScreen().getDiagonalLength()) + '\"';
    }

    public static String getDimensionString(Device device) {
        Dimension size = device.getScreenSize(device.getDefaultState().getOrientation());
        return size == null ? "Unknown Resolution" : String.format(Locale.getDefault(), "%dx%d", size.width, size.height);
    }

    public static String getDensityString(Device device) {
        return device.getDefaultHardware().getScreen().getPixelDensity().getResourceValue();
    }

    private void createUIComponents() {
        this.myCategoryList = new TableView();
        this.myTable = new TableView();
        this.myRefreshButton = new JButton(AllIcons.Actions.Refresh);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateSearchResults(this.getText(e.getDocument()));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSearchResults(this.getText(e.getDocument()));
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSearchResults(this.getText(e.getDocument()));
    }

    private String getText(Document d) {
        try {
            return d.getText(0, d.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private void updateSearchResults(final String searchString) {
        if (searchString.isEmpty()) {
            if (((String)this.myCategoryModel.getItem(this.myCategoryModel.getRowCount() - 1)).equals(SEARCH_RESULTS)) {
                this.myCategoryModel.removeRow(this.myCategoryModel.getRowCount() - 1);
                this.setCategory((String)this.myCategoryList.getRow(0));
            }
            return;
        }
        if (!((String)this.myCategoryModel.getItem(this.myCategoryModel.getRowCount() - 1)).equals(SEARCH_RESULTS)) {
            this.myCategoryModel.addRow((Object)SEARCH_RESULTS);
            this.myCategoryList.setSelection((Collection)ImmutableSet.of((Object)SEARCH_RESULTS));
        }
        ArrayList items = Lists.newArrayList((Iterable)Iterables.filter(this.myDevices, (Predicate)new Predicate<Device>(){

            public boolean apply(Device input) {
                return input.getDisplayName().toLowerCase().contains(searchString.toLowerCase());
            }
        }));
        this.myModel.setItems((List)items);
        this.notifyCategoryListeners(null, items);
    }

    @Override
    public Device getDevice() {
        return (Device)this.myTable.getSelectedObject();
    }

    @Override
    public void setDevice(Device device) {
        this.setSelectedDevice(device);
    }

    @Override
    public void refreshDevices() {
        this.refreshDeviceProfiles();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SearchTextField searchTextField;
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 8, 2, 1, 7, null, new Dimension(100, -1), new Dimension(100, -1)));
        TableView<String> tableView = this.myCategoryList;
        jBScrollPane.setViewportView((Component)tableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        TableView<Device> tableView2 = this.myTable;
        jBScrollPane2.setViewportView((Component)tableView2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCreateProfileButton = jButton2 = new JButton();
        jButton2.setText("New Hardware Profile");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myImportProfileButton = jButton = new JButton();
        ((Component)jButton).setVisible(true);
        jButton.setText("Import Hardware Profiles");
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JButton jButton3 = this.myRefreshButton;
        jButton3.setText("");
        jPanel2.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySearchTextField = searchTextField = new SearchTextField();
        jPanel.add((Component)searchTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static interface DeviceCategorySelectionListener {
        public void onCategorySelectionChanged(String var1, List<Device> var2);
    }

    public static interface DeviceDefinitionSelectionListener {
        public void onDeviceSelectionChanged(Device var1);
    }

    private abstract class DeviceColumnInfo
    extends ColumnInfo<Device, String> {
        private final int myWidth;

        public Comparator<Device> getComparator() {
            return new Comparator<Device>(){

                @Override
                public int compare(Device o1, Device o2) {
                    if (o1 == null || DeviceColumnInfo.this.valueOf(o1) == null) {
                        return -1;
                    }
                    if (o2 == null || DeviceColumnInfo.this.valueOf(o2) == null) {
                        return 1;
                    }
                    return ((String)DeviceColumnInfo.this.valueOf(o1)).compareTo((String)DeviceColumnInfo.this.valueOf(o2));
                }
            };
        }

        public DeviceColumnInfo(String name, int width) {
            super(name);
            this.myWidth = width;
        }

        public DeviceColumnInfo(String name) {
            this(name, -1);
        }

        public TableCellRenderer getRenderer(Device device) {
            return DeviceDefinitionList.this.myRenderer;
        }

        public int getWidth(JTable table) {
            return this.myWidth;
        }
    }
}

