/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;

public class PsiFileAndLineNavigation
implements NavigationItem {
    private PsiFile myPsiFile;
    private int myLineNumber;

    public PsiFileAndLineNavigation(PsiFile file, int lineNumber) {
        this.myPsiFile = file;
        this.myLineNumber = lineNumber;
    }

    public static PsiFileAndLineNavigation[] wrappersForClassName(Project project, String className, int lineNumber) {
        if (className != null) {
            PsiClass[] classes;
            ArrayList<PsiFileAndLineNavigation> files = new ArrayList<PsiFileAndLineNavigation>();
            for (PsiClass c : classes = JavaPsiFacade.getInstance((Project)project).findClasses(className, GlobalSearchScope.allScope((Project)project))) {
                files.add(new PsiFileAndLineNavigation((PsiFile)c.getContainingFile().getNavigationElement(), lineNumber));
            }
            return files.toArray(new PsiFileAndLineNavigation[files.size()]);
        }
        return null;
    }

    public PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    public String getName() {
        return this.myPsiFile.getName();
    }

    public ItemPresentation getPresentation() {
        return this.myPsiFile.getPresentation();
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(this.myPsiFile.getProject(), this.myPsiFile.getVirtualFile(), this.myLineNumber);
        fileDescriptor.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myPsiFile.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myPsiFile.canNavigateToSource();
    }
}

