/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.api;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import java.util.List;

public final class StatementFilter
extends JavaRecursiveElementVisitor {
    private String myFilterString;
    private List<PsiStatement> myStatements = Lists.newArrayList();

    public StatementFilter(String filterString) {
        this.myFilterString = CharMatcher.WHITESPACE.removeFrom((CharSequence)filterString);
    }

    public List<PsiStatement> getStatements() {
        return this.myStatements;
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        if (CharMatcher.WHITESPACE.removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        if (CharMatcher.WHITESPACE.removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    public static List<PsiStatement> filterCodeBlock(String filterString, PsiCodeBlock codeBlock) {
        StatementFilter filter = new StatementFilter(filterString);
        codeBlock.accept((PsiElementVisitor)filter);
        return filter.getStatements();
    }

    public static List<PsiStatement> filterStatements(String filterString, List<PsiStatement> statements) {
        StatementFilter filter = new StatementFilter(filterString);
        for (PsiStatement statement : statements) {
            statement.accept((PsiElementVisitor)filter);
        }
        return filter.getStatements();
    }
}

