/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger.ui;

import com.google.gct.idea.debugger.CloudLineBreakpointProperties;
import com.google.gct.idea.debugger.CloudLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreeNode;

public class BreakpointConfigurationPanel
extends XBreakpointCustomPropertiesPanel<XLineBreakpoint<CloudLineBreakpointProperties>>
implements Disposable,
XWatchesView {
    private static final String CONDITION_HISTORY_ID = "breakpointCondition";
    private static final Logger LOG = Logger.getInstance(BreakpointConfigurationPanel.class);
    private final CloudLineBreakpointType myCloudLineBreakpointType;
    private XDebuggerExpressionComboBox myConditionComboBox;
    private JBCheckBox myConditionEnabledCheckbox;
    private JPanel myConditionEnabledPanel;
    private JPanel myConditionExpressionPanel;
    private JPanel myConditionPanel;
    private JBCheckBox myEnabledCheckbox;
    private JBLabel myErrorDescription;
    private JBLabel myErrorLabel;
    private JPanel myErrorPanel;
    private JPanel myMainPanel;
    private WatchesRootNode myRootNode;
    private JSeparator mySeparator;
    private JBCheckBox mySuspendCheckbox;
    private XDebuggerTreePanel myTreePanel;
    private JBLabel myWatchLabel;
    private JPanel myWatchPanel;

    public BreakpointConfigurationPanel(CloudLineBreakpointType cloudLineBreakpointType) {
        this.myCloudLineBreakpointType = cloudLineBreakpointType;
        this.$$$setupUI$$$();
        this.myMainPanel.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 1L) != 0L && BreakpointConfigurationPanel.this.myMainPanel.getParent() == e.getChangedParent() && BreakpointConfigurationPanel.this.myMainPanel.getParent() != null) {
                    BreakpointConfigurationPanel.trim(BreakpointConfigurationPanel.this.myMainPanel);
                }
            }
        });
        this.myWatchPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JRootPane pane = BreakpointConfigurationPanel.this.myWatchPanel.getRootPane();
                if (pane != null) {
                    BreakpointConfigurationPanel.this.myWatchPanel.setVisible(UIUtil.isDialogRootPane((JRootPane)pane));
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    public void addWatchExpression(XExpression expression, int index, boolean navigateToWatchNode) {
        this.myRootNode.addWatchExpression(null, expression, index, navigateToWatchNode);
    }

    public void dispose() {
        if (this.myTreePanel != null && this.myTreePanel.getTree() != null) {
            this.myTreePanel.getTree().dispose();
        }
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void loadFrom(XLineBreakpoint<CloudLineBreakpointProperties> breakpoint) {
        XBreakpointBase lineBreakpointImpl = breakpoint instanceof XBreakpointBase ? (XBreakpointBase)breakpoint : null;
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint);
        CloudLineBreakpointType.CloudLineBreakpoint cloudBreakpoint = null;
        if (javaBreakpoint instanceof CloudLineBreakpointType.CloudLineBreakpoint) {
            cloudBreakpoint = (CloudLineBreakpointType.CloudLineBreakpoint)javaBreakpoint;
        }
        if (cloudBreakpoint == null || lineBreakpointImpl == null) {
            return;
        }
        XDebuggerEditorsProvider debuggerEditorsProvider = this.myCloudLineBreakpointType.getEditorsProvider(breakpoint, cloudBreakpoint.getProject());
        if (debuggerEditorsProvider != null) {
            this.myTreePanel = new XDebuggerTreePanel(cloudBreakpoint.getProject(), debuggerEditorsProvider, (Disposable)this, breakpoint.getSourcePosition(), "GoogleCloudTools.BreakpointWatchContextMenu", null);
            ArrayList<XExpression> watches = new ArrayList<XExpression>();
            for (String watchExpression : ((CloudLineBreakpointProperties)breakpoint.getProperties()).getWatchExpressions()) {
                watches.add(debuggerEditorsProvider.createExpression(((XBreakpointBase)breakpoint).getProject(), (Document)new DocumentImpl(watchExpression), BreakpointConfigurationPanel.getFileTypeLanguage(breakpoint), EvaluationMode.EXPRESSION));
            }
            this.myRootNode = new WatchesRootNode(this.myTreePanel.getTree(), (XWatchesView)this, watches.toArray(new XExpression[watches.size()]));
            this.myTreePanel.getTree().setRoot((XDebuggerTreeNode)this.myRootNode, false);
            this.myWatchPanel.removeAll();
            this.myWatchPanel.add((Component)this.myWatchLabel, "North");
            this.myTreePanel.getTree().getEmptyText().setText("There are no custom watches for this snapshot location.");
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTreePanel.getTree()).disableUpDownActions();
            decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
            decorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    BreakpointConfigurationPanel.this.executeAction("XDebugger.NewWatch");
                }
            });
            decorator.setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    BreakpointConfigurationPanel.this.executeAction("XDebugger.RemoveWatch");
                }
            });
            CustomLineBorder border = new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, SystemInfo.isMac ? 1 : 0, 0, SystemInfo.isMac ? 0 : 1, 0);
            decorator.setToolbarBorder((Border)border);
            this.myWatchPanel.add((Component)decorator.createPanel(), "Center");
            this.myConditionEnabledCheckbox = new JBCheckBox(XDebuggerBundle.message((String)"xbreakpoints.condition.checkbox", (Object[])new Object[0]));
            this.myConditionEnabledPanel.add((Component)this.myConditionEnabledCheckbox, "Center");
            this.myConditionComboBox = new XDebuggerExpressionComboBox(cloudBreakpoint.getProject(), debuggerEditorsProvider, CONDITION_HISTORY_ID, breakpoint.getSourcePosition());
            JComponent conditionComponent = this.myConditionComboBox.getComponent();
            this.myConditionExpressionPanel.add((Component)conditionComponent, "Center");
            this.myConditionEnabledCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BreakpointConfigurationPanel.this.onCheckboxChanged();
                }
            });
            DebuggerUIUtil.focusEditorOnCheck((JCheckBox)this.myConditionEnabledCheckbox, (JComponent)this.myConditionComboBox.getEditorComponent());
        } else {
            this.myConditionPanel.setVisible(false);
        }
        if (this.myConditionComboBox != null) {
            XExpression condition = lineBreakpointImpl.getConditionExpressionInt();
            this.myConditionComboBox.setExpression(condition);
            this.myConditionEnabledCheckbox.setSelected(lineBreakpointImpl.isConditionEnabled() && condition != null);
            this.onCheckboxChanged();
        }
        this.myEnabledCheckbox.setSelected(breakpoint.isEnabled());
        this.myEnabledCheckbox.setText(XBreakpointUtil.getShortText(breakpoint) + " enabled");
        this.myErrorPanel.setVisible(cloudBreakpoint.hasError());
        if (cloudBreakpoint.hasError()) {
            this.myErrorLabel.setForeground((Color)JBColor.RED);
            this.myErrorDescription.setText(cloudBreakpoint.getErrorMessage());
        }
    }

    public void removeAllWatches() {
        this.myRootNode.removeAllChildren();
    }

    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        List children = this.myRootNode.getAllChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove = new ArrayList<XDebuggerTreeNode>();
        if (children != null) {
            for (XDebuggerTreeNode xDebuggerTreeNode : nodes) {
                int index = children.indexOf(xDebuggerTreeNode);
                if (index == -1) continue;
                toRemove.add(xDebuggerTreeNode);
                minIndex = Math.min(minIndex, index);
            }
        }
        this.myRootNode.removeChildren(toRemove);
        List newChildren = this.myRootNode.getAllChildren();
        if (newChildren != null && !newChildren.isEmpty()) {
            WatchNode watchNode = minIndex < newChildren.size() ? (WatchNode)newChildren.get(minIndex) : (WatchNode)newChildren.get(newChildren.size() - 1);
            TreeUtil.selectNode((JTree)this.myTreePanel.getTree(), (TreeNode)watchNode);
        }
    }

    public void saveTo(final XLineBreakpoint<CloudLineBreakpointProperties> xIdebreakpoint) {
        XBreakpointBase lineBreakpointImpl;
        CloudLineBreakpointProperties properties = (CloudLineBreakpointProperties)xIdebreakpoint.getProperties();
        if (properties == null) {
            LOG.error("Could not save changes to the breakpoint because for some reason it does not have cloud properties.");
            return;
        }
        XBreakpointBase xBreakpointBase = lineBreakpointImpl = xIdebreakpoint instanceof XBreakpointBase ? (XBreakpointBase)xIdebreakpoint : null;
        if (this.myConditionComboBox != null && lineBreakpointImpl != null) {
            XExpression expression = this.myConditionComboBox.getExpression();
            XExpression condition = !XDebuggerUtilImpl.isEmptyExpression((XExpression)expression) ? expression : null;
            lineBreakpointImpl.setConditionEnabled(condition == null || this.myConditionEnabledCheckbox.isSelected());
            lineBreakpointImpl.setConditionExpression(condition);
            this.myConditionComboBox.saveTextInHistory();
        }
        if (xIdebreakpoint.isEnabled() != this.myEnabledCheckbox.isSelected()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    xIdebreakpoint.setEnabled(BreakpointConfigurationPanel.this.myEnabledCheckbox.isSelected());
                }
            });
        }
        if (this.myRootNode != null && lineBreakpointImpl != null) {
            ArrayList<String> expressionsToSave = new ArrayList<String>();
            for (WatchNode node : this.myRootNode.getAllChildren()) {
                expressionsToSave.add(node.getExpression().getExpression());
            }
            if (properties.setWatchExpressions(expressionsToSave.toArray(new String[expressionsToSave.size()]))) {
                lineBreakpointImpl.fireBreakpointChanged();
            }
        }
    }

    private static Language getFileTypeLanguage(XLineBreakpoint<CloudLineBreakpointProperties> breakpoint) {
        FileType fileType;
        if (breakpoint.getSourcePosition() != null && (fileType = breakpoint.getSourcePosition().getFile().getFileType()) instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).getLanguage();
        }
        return null;
    }

    private static void trim(Component onlyValidChild) {
        Container container = onlyValidChild.getParent();
        if (container != null) {
            Component[] children;
            for (Component child : children = container.getComponents()) {
                if (child == onlyValidChild) continue;
                child.setVisible(false);
            }
            BreakpointConfigurationPanel.trim(container);
        }
    }

    private void createUIComponents() {
        this.mySeparator = new JSeparator(0);
        this.myWatchPanel = new MyPanel();
    }

    private void executeAction(String watch) {
        AnAction action = ActionManager.getInstance().getAction(watch);
        Presentation presentation = action.getTemplatePresentation().clone();
        DataContext context = DataManager.getInstance().getDataContext((Component)this.myTreePanel.getTree());
        AnActionEvent actionEvent = new AnActionEvent(null, context, "DebuggerToolbar", presentation, ActionManager.getInstance(), 0);
        action.actionPerformed(actionEvent);
    }

    private void onCheckboxChanged() {
        if (this.myConditionComboBox != null) {
            this.myConditionComboBox.setEnabled(this.myConditionEnabledCheckbox.isSelected());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JBLabel jBLabel3;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel5;
        this.createUIComponents();
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 10, 0), -1, -1, false, false));
        this.myEnabledCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Enabled");
        jBCheckBox2.setMnemonic('E');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        Font font = jBCheckBox2.getFont();
        jBCheckBox2.setFont(new Font(font.getName(), 1, font.getSize()));
        jPanel5.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySuspendCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.suspendnotavailable"));
        jBCheckBox.setEnabled(false);
        jPanel5.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConditionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myConditionExpressionPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null, 1));
        this.myConditionEnabledPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.neversuspends"));
        jBLabel4.setHorizontalAlignment(10);
        jBLabel4.setVerticalTextPosition(0);
        Font font2 = jBLabel4.getFont();
        jBLabel4.setFont(new Font(font2.getName(), 2, 10));
        jBLabel4.setVerticalAlignment(0);
        jPanel5.add((Component)jBLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.enabledinfo"));
        jBLabel5.setVerticalTextPosition(0);
        Font font3 = jBLabel5.getFont();
        jBLabel5.setFont(new Font(font3.getName(), 2, 10));
        jBLabel5.setVerticalAlignment(0);
        jPanel5.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 3));
        JSeparator jSeparator = this.mySeparator;
        jPanel5.add((Component)jSeparator, new GridConstraints(2, 0, 1, 1, 1, 1, 7, 1, null, new Dimension(0, -1), null));
        JPanel jPanel6 = this.myWatchPanel;
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel6, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 1, null, new Dimension(-1, 100), null));
        this.myWatchLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Watches:");
        jPanel6.add((Component)jBLabel3, "North");
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Error:");
        jBLabel2.setForeground(new Color(-65536));
        Font font4 = jBLabel2.getFont();
        jBLabel2.setFont(new Font(font4.getName(), 1, font4.getSize()));
        jBLabel2.setFocusable(false);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myErrorDescription = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.errorset"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            this.setLayout(new BorderLayout());
        }

        public Object getData(String dataId) {
            if (XWatchesView.DATA_KEY.is(dataId)) {
                return BreakpointConfigurationPanel.this;
            }
            return null;
        }
    }
}

