/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;

public class ConstructorInspection
extends EndpointInspectionBase {
    public String getStaticDescription() {
        return EndpointBundle.message("constructor.description", new Object[0]);
    }

    public String getDisplayName() {
        return EndpointBundle.message("constructor.name", new Object[0]);
    }

    public String getShortName() {
        return EndpointBundle.message("constructor.short.name", new Object[0]);
    }

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitClass(PsiClass psiClass) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)psiClass)) {
                    return;
                }
                PsiMethod[] allConstructors = psiClass.getConstructors();
                if (allConstructors.length == 0) {
                    return;
                }
                for (PsiMethod aConstructor : allConstructors) {
                    if (!EndpointUtilities.isPublicNullaryConstructor(aConstructor)) continue;
                    return;
                }
                holder.registerProblem((PsiElement)psiClass, "Each class that is within an API must have a public nullary constructor.", new LocalQuickFix[]{new MyQuickFix(psiClass)});
            }
        };
    }

    public class MyQuickFix
    implements LocalQuickFix {
        private final PsiClass psiClass;

        public MyQuickFix(PsiClass psiClass) {
            this.psiClass = psiClass;
        }

        public String getName() {
            return this.getFamilyName() + ": Add nullary constructor";
        }

        public String getFamilyName() {
            return ConstructorInspection.this.getDisplayName();
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            for (PsiMethod aConstructor : this.psiClass.getConstructors()) {
                if (!EndpointUtilities.isPublicNullaryConstructor(aConstructor)) continue;
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod newConstructor = factory.createMethodFromText("public " + this.psiClass.getName() + "() { }", (PsiElement)this.psiClass);
            PsiMethod[] psiMethods = this.psiClass.getMethods();
            PsiMethod firstMethod = psiMethods.length == 0 ? null : psiMethods[0];
            this.psiClass.addBefore((PsiElement)newConstructor, (PsiElement)firstMethod);
        }
    }
}

