/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.update.SvnUpdateContext;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class UpdateEventHandler
implements ProgressTracker {
    private ProgressIndicator myProgressIndicator;
    private UpdatedFiles myUpdatedFiles;
    private int myExternalsCount;
    private final SvnVcs myVCS;
    private final SvnUpdateContext mySequentialUpdatesContext;
    private final Map<File, SVNURL> myUrlToCheckForSwitch;
    private final Stack<List<Pair<String, String>>> myFilesWaitingForRevision;
    protected String myText;
    protected String myText2;

    public UpdateEventHandler(SvnVcs vcs, ProgressIndicator progressIndicator, SvnUpdateContext sequentialUpdatesContext) {
        this.myProgressIndicator = progressIndicator;
        this.myVCS = vcs;
        this.mySequentialUpdatesContext = sequentialUpdatesContext;
        this.myExternalsCount = 1;
        this.myUrlToCheckForSwitch = new HashMap<File, SVNURL>();
        this.myFilesWaitingForRevision = ContainerUtil.newStack();
    }

    public void startUpdate() {
        this.myFilesWaitingForRevision.push((Object)ContainerUtil.newArrayList());
    }

    public void finishUpdate() {
        while (!this.myFilesWaitingForRevision.isEmpty()) {
            this.setRevisionForWaitingFiles(CommitInfo.EMPTY.getRevision());
        }
    }

    public void addToSwitch(File file, SVNURL url) {
        this.myUrlToCheckForSwitch.put(file, url);
    }

    public void setUpdatedFiles(UpdatedFiles updatedFiles) {
        this.myUpdatedFiles = updatedFiles;
    }

    public void consume(ProgressEvent event) {
        if (event == null || event.getFile() == null) {
            return;
        }
        String path = event.getFile().getAbsolutePath();
        String displayPath = event.getFile().getName();
        this.myText2 = null;
        this.myText = null;
        if (this.handleInDescendants(event)) {
            this.updateProgressIndicator();
            return;
        }
        if (event.getAction() == EventAction.TREE_CONFLICT) {
            this.myText2 = SvnBundle.message("progress.text2.treeconflicted", displayPath);
            this.updateProgressIndicator();
            this.myUpdatedFiles.registerGroup(UpdateEventHandler.createFileGroup(VcsBundle.message((String)"update.group.name.merged.with.tree.conflicts", (Object[])new Object[0]), "MERGED_WITH_TREE_CONFLICT"));
            this.addFileToGroup("MERGED_WITH_TREE_CONFLICT", event);
        }
        if (event.getAction() == EventAction.UPDATE_ADD || event.getAction() == EventAction.ADD) {
            this.myText2 = SvnBundle.message("progress.text2.added", displayPath);
            if (event.getContentsStatus() == StatusType.CONFLICTED || event.getPropertiesStatus() == StatusType.CONFLICTED) {
                this.addFileToGroup("MERGED_WITH_CONFLICTS", event);
                this.myText2 = SvnBundle.message("progress.text2.conflicted", displayPath);
            } else if (this.myUpdatedFiles.getGroupById("REMOVED_FROM_REPOSITORY").getFiles().contains(path)) {
                this.myUpdatedFiles.getGroupById("REMOVED_FROM_REPOSITORY").getFiles().remove(path);
                if (this.myUpdatedFiles.getGroupById("replaced") == null) {
                    this.myUpdatedFiles.registerGroup(UpdateEventHandler.createFileGroup(SvnBundle.message("status.group.name.replaced", new Object[0]), "replaced"));
                }
                this.addFileToGroup("replaced", event);
            } else {
                this.addFileToGroup("CREATED", event);
            }
        } else {
            if (event.getAction() == EventAction.UPDATE_NONE) {
                return;
            }
            if (event.getAction() == EventAction.UPDATE_DELETE) {
                this.myText2 = SvnBundle.message("progress.text2.deleted", displayPath);
                this.addFileToGroup("REMOVED_FROM_REPOSITORY", event);
            } else if (event.getAction() == EventAction.UPDATE_UPDATE) {
                this.possiblySwitched(event);
                if (event.getContentsStatus() == StatusType.CONFLICTED || event.getPropertiesStatus() == StatusType.CONFLICTED) {
                    if (event.getContentsStatus() == StatusType.CONFLICTED) {
                        this.addFileToGroup("MERGED_WITH_CONFLICTS", event);
                    }
                    if (event.getPropertiesStatus() == StatusType.CONFLICTED) {
                        this.addFileToGroup("MERGED_WITH_PROPERTY_CONFLICT", event);
                    }
                    this.myText2 = SvnBundle.message("progress.text2.conflicted", displayPath);
                } else if (event.getContentsStatus() == StatusType.MERGED || event.getPropertiesStatus() == StatusType.MERGED) {
                    this.myText2 = SvnBundle.message("progres.text2.merged", displayPath);
                    this.addFileToGroup("MERGED", event);
                } else if (event.getContentsStatus() == StatusType.CHANGED || event.getPropertiesStatus() == StatusType.CHANGED) {
                    this.myText2 = SvnBundle.message("progres.text2.updated", displayPath);
                    this.addFileToGroup("UPDATED", event);
                } else if (event.getContentsStatus() == StatusType.UNCHANGED && (event.getPropertiesStatus() == StatusType.UNCHANGED || event.getPropertiesStatus() == StatusType.UNKNOWN)) {
                    this.myText2 = SvnBundle.message("progres.text2.updated", displayPath);
                } else if (StatusType.INAPPLICABLE.equals((Object)event.getContentsStatus()) && (event.getPropertiesStatus() == StatusType.UNCHANGED || event.getPropertiesStatus() == StatusType.UNKNOWN)) {
                    this.myText2 = SvnBundle.message("progres.text2.updated", displayPath);
                } else {
                    this.myText2 = "";
                    this.addFileToGroup("UNKNOWN", event);
                }
            } else if (event.getAction() == EventAction.UPDATE_EXTERNAL) {
                if (this.mySequentialUpdatesContext != null) {
                    this.mySequentialUpdatesContext.registerExternalRootBeingUpdated(event.getFile());
                }
                this.myFilesWaitingForRevision.push((Object)ContainerUtil.newArrayList());
                ++this.myExternalsCount;
                this.myText = SvnBundle.message("progress.text.updating.external.location", event.getFile().getAbsolutePath());
            } else if (event.getAction() == EventAction.RESTORE) {
                this.myText2 = SvnBundle.message("progress.text2.restored.file", displayPath);
                this.addFileToGroup("RESTORED", event);
            } else if (event.getAction() == EventAction.UPDATE_COMPLETED && event.getRevision() >= 0L) {
                this.possiblySwitched(event);
                this.setRevisionForWaitingFiles(event.getRevision());
                --this.myExternalsCount;
                this.myText2 = SvnBundle.message("progres.text2.updated.to.revision", event.getRevision());
                if (this.myExternalsCount == 0) {
                    this.myExternalsCount = 1;
                    StatusBar.Info.set((String)SvnBundle.message("status.text.updated.to.revision", event.getRevision()), (Project)this.myVCS.getProject());
                }
            } else if (event.getAction() == EventAction.SKIP) {
                this.myText2 = SvnBundle.message("progress.text2.skipped.file", displayPath);
                this.addFileToGroup("SKIPPED", event);
            }
        }
        this.updateProgressIndicator();
    }

    private void possiblySwitched(ProgressEvent event) {
        File file = event.getFile();
        if (file == null) {
            return;
        }
        SVNURL wasUrl = this.myUrlToCheckForSwitch.get(file);
        if (wasUrl != null && !wasUrl.equals((Object)event.getURL())) {
            this.myUrlToCheckForSwitch.remove(file);
            this.addFileToGroup("SWITCHED", event);
        }
    }

    private boolean itemSwitched(ProgressEvent event) {
        File file = event.getFile();
        SvnFileUrlMapping urlMapping = this.myVCS.getSvnFileUrlMapping();
        SVNURL currentUrl = urlMapping.getUrlForFile(file);
        return currentUrl != null && !currentUrl.equals((Object)event.getURL());
    }

    private void updateProgressIndicator() {
        if (this.myProgressIndicator != null) {
            if (this.myText != null) {
                this.myProgressIndicator.setText(this.myText);
            }
            if (this.myText2 != null) {
                this.myProgressIndicator.setText2(this.myText2);
            }
        }
    }

    protected boolean handleInDescendants(ProgressEvent event) {
        return false;
    }

    protected void addFileToGroup(String id, ProgressEvent event) {
        FileGroup fileGroup = this.myUpdatedFiles.getGroupById(id);
        String path = event.getFile().getAbsolutePath();
        ((List)this.myFilesWaitingForRevision.peek()).add(Pair.create((Object)id, (Object)path));
        if (event.getErrorMessage() != null) {
            fileGroup.addError(path, event.getErrorMessage().getMessage());
        }
    }

    private void setRevisionForWaitingFiles(long revisionNumber) {
        SvnRevisionNumber revision = new SvnRevisionNumber(SVNRevision.create((long)revisionNumber));
        for (Pair pair : (List)this.myFilesWaitingForRevision.pop()) {
            FileGroup fileGroup = this.myUpdatedFiles.getGroupById((String)pair.getFirst());
            fileGroup.add((String)pair.getSecond(), SvnVcs.getKey(), (VcsRevisionNumber)revision);
        }
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.checkCanceled();
            if (this.myProgressIndicator.isCanceled()) {
                SVNErrorManager.cancel((String)SvnBundle.message("exception.text.update.operation.cancelled", new Object[0]), (SVNLogType)SVNLogType.DEFAULT);
            }
        }
    }

    private static FileGroup createFileGroup(String name, String id) {
        return new FileGroup(name, name, false, id, true);
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
    }
}

