/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Component;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.update.UpdateRootInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class AutoSvnUpdater
extends AbstractCommonUpdateAction {
    private final Project myProject;
    private final FilePath[] myRoots;

    public AutoSvnUpdater(Project project, FilePath[] roots) {
        super((ActionInfo)BlindUpdateAction.ourInstance, (ScopeInfo)new AutoUpdateScope(roots), false);
        this.myProject = project;
        this.myRoots = roots;
    }

    public static void run(AutoSvnUpdater updater, String title) {
        JComponent frame = WindowManager.getInstance().getIdeFrame(updater.myProject).getComponent();
        updater.getTemplatePresentation().setText(title);
        updater.actionPerformed(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)frame), "unknown", updater.getTemplatePresentation(), ActionManager.getInstance(), 0));
    }

    protected void actionPerformed(VcsContext context) {
        SvnConfiguration configuration17 = SvnConfiguration.getInstance(this.myProject);
        configuration17.setForceUpdate(false);
        configuration17.setUpdateLockOnDemand(false);
        configuration17.setUpdateDepth(Depth.INFINITY);
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        for (FilePath root : this.myRoots) {
            this.configureUpdateRootInfo(root, configuration17.getUpdateRootInfo(root.getIOFile(), vcs));
        }
        super.actionPerformed(context);
    }

    protected void configureUpdateRootInfo(FilePath root, UpdateRootInfo info) {
        info.setRevision(SVNRevision.HEAD);
        info.setUpdateToRevision(false);
    }

    protected boolean filterRootsBeforeAction() {
        return false;
    }

    private static class AutoUpdateScope
    implements ScopeInfo {
        private final FilePath[] myRoots;

        private AutoUpdateScope(FilePath[] roots) {
            this.myRoots = roots;
        }

        public FilePath[] getRoots(VcsContext context, ActionInfo actionInfo) {
            return this.myRoots;
        }

        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            return "Subversion";
        }

        public boolean filterExistsInVcs() {
            return false;
        }
    }

    private static class BlindUpdateAction
    implements ActionInfo {
        private static final BlindUpdateAction ourInstance = new BlindUpdateAction();

        private BlindUpdateAction() {
        }

        public boolean showOptions(Project project) {
            return false;
        }

        public UpdateEnvironment getEnvironment(AbstractVcs vcs) {
            return vcs.getUpdateEnvironment();
        }

        public UpdateOrStatusOptionsDialog createOptionsDialog(Project project, LinkedHashMap<Configurable, AbstractVcs> envToConfMap, String scopeName) {
            return null;
        }

        public String getActionName(String scopeName) {
            return ActionInfo.UPDATE.getActionName(scopeName);
        }

        public String getActionName() {
            return ActionInfo.UPDATE.getActionName();
        }

        public String getGroupName(FileGroup fileGroup) {
            return ActionInfo.UPDATE.getGroupName(fileGroup);
        }

        public boolean canGroupByChangelist() {
            return ActionInfo.UPDATE.canGroupByChangelist();
        }

        public boolean canChangeFileStatus() {
            return ActionInfo.UPDATE.canChangeFileStatus();
        }
    }
}

