/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public enum StatusType {
    UNUSED("unused"),
    INAPPLICABLE("inapplicable"),
    UNKNOWN("unknown"),
    UNCHANGED("unchanged"),
    MISSING("missing"),
    OBSTRUCTED("obstructed"),
    CHANGED("changed"),
    MERGED("merged"),
    CONFLICTED("conflicted"),
    STATUS_NONE("none"),
    STATUS_NORMAL("normal", ' '),
    STATUS_MODIFIED("modified", 'M'),
    STATUS_ADDED("added", 'A'),
    STATUS_DELETED("deleted", 'D'),
    STATUS_UNVERSIONED("unversioned", '?'),
    STATUS_MISSING("missing", '!'),
    STATUS_REPLACED("replaced", 'R'),
    STATUS_CONFLICTED("conflicted", 'C'),
    STATUS_OBSTRUCTED("obstructed", '~'),
    STATUS_IGNORED("ignored", 'I'),
    STATUS_INCOMPLETE("incomplete", '!'),
    STATUS_EXTERNAL("external", 'X');

    private static final String STATUS_PREFIX = "STATUS_";
    private static final Map<String, StatusType> ourOtherStatusTypes;
    private static final Map<String, StatusType> ourStatusTypesForStatusOperation;
    private String myName;
    private char myCode;

    private StatusType(String name) {
        this(name, ' ');
    }

    private StatusType(String name, char code) {
        this.myName = name;
        this.myCode = code;
    }

    public char getCode() {
        return this.myCode;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(StatusType action) {
        (action.name().startsWith(STATUS_PREFIX) ? ourStatusTypesForStatusOperation : ourOtherStatusTypes).put(action.myName, action);
    }

    public static StatusType from(SVNStatusType type) {
        StatusType result = ourOtherStatusTypes.get(type.toString());
        if (type != SVNStatusType.CONFLICTED && type != SVNStatusType.OBSTRUCTED && type != SVNStatusType.MISSING) {
            result = (StatusType)((Object)ObjectUtils.chooseNotNull((Object)((Object)ourStatusTypesForStatusOperation.get(type.toString())), (Object)((Object)result)));
        }
        return (StatusType)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)UNUSED)));
    }

    public static StatusType forStatusOperation(String statusName) {
        return ourStatusTypesForStatusOperation.get(statusName);
    }

    static {
        ourOtherStatusTypes = ContainerUtil.newHashMap();
        ourStatusTypesForStatusOperation = ContainerUtil.newHashMap();
        for (StatusType action : StatusType.values()) {
            StatusType.register(action);
        }
    }
}

