/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.rollback;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.rollback.ChangesAfterPathComparator;
import org.jetbrains.idea.svn.rollback.ChangesChecker;
import org.jetbrains.idea.svn.rollback.Reverter;
import org.jetbrains.idea.svn.rollback.UnversionedAndNotTouchedFilesGroupCollector;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRollbackEnvironment
extends DefaultRollbackEnvironment {
    private final SvnVcs mySvnVcs;

    public SvnRollbackEnvironment(SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    public String getRollbackOperationName() {
        return SvnBundle.message("action.name.revert", new Object[0]);
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> exceptions, RollbackProgressListener listener) {
        listener.indeterminate();
        for (Set<Change> collection : SvnUtil.splitChangesIntoWc(this.mySvnVcs, changes).values()) {
            List sortedChanges = ContainerUtil.sorted(collection, (Comparator)ChangesAfterPathComparator.getInstance());
            this.rollbackGroupForWc(sortedChanges, exceptions, listener);
        }
    }

    private void rollbackGroupForWc(List<Change> changes, List<VcsException> exceptions, RollbackProgressListener listener) {
        UnversionedAndNotTouchedFilesGroupCollector collector = new UnversionedAndNotTouchedFilesGroupCollector();
        ChangesChecker checker = new ChangesChecker(this.mySvnVcs, collector);
        checker.gather(changes);
        exceptions.addAll(checker.getExceptions());
        Reverter reverter = new Reverter(this.mySvnVcs, listener, exceptions);
        reverter.moveRenamesToTmp(collector);
        reverter.revert(checker.getForAdds(), true);
        reverter.revert(checker.getForDeletes(), true);
        reverter.revert(checker.getForEdits(), false);
        reverter.moveGroup();
        for (Couple<File> pair : collector.getToBeDeleted()) {
            if (!((File)pair.getFirst()).exists()) continue;
            FileUtil.delete((File)((File)pair.getSecond()));
        }
    }

    public void rollbackMissingFileDeletion(List<FilePath> filePaths, List<VcsException> exceptions, RollbackProgressListener listener) {
        for (FilePath filePath : filePaths) {
            listener.accept(filePath);
            try {
                this.revertFileOrDir(filePath);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
            catch (SVNException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
        }
    }

    private void revertFileOrDir(FilePath filePath) throws SVNException, VcsException {
        File file = filePath.getIOFile();
        Info info = this.mySvnVcs.getInfo(file);
        if (info != null) {
            if (info.isFile()) {
                this.doRevert(file, false);
            } else if ("add".equals(info.getSchedule()) || this.is17OrGreaterCopy(file, info)) {
                this.doRevert(file, true);
            } else {
                this.mySvnVcs.getSvnKitManager().createUpdateClient().doUpdate(file, SVNRevision.HEAD, true);
            }
        } else {
            throw new VcsException("Can not get 'svn info' for " + file.getPath());
        }
    }

    private void doRevert(File path, boolean recursive) throws VcsException {
        this.mySvnVcs.getFactory(path).createRevertClient().revert(Collections.singletonList(path), Depth.allOrFiles(recursive), null);
    }

    private boolean is17OrGreaterCopy(File file, Info info) throws VcsException {
        WorkingCopy copy = this.mySvnVcs.getRootsToWorkingCopies().getMatchingCopy(info.getURL());
        return copy != null ? copy.is17Copy() : this.mySvnVcs.getWorkingCopyFormat(file).isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN);
    }

    public static boolean isMoveRenameReplace(Change c) {
        if (c.getAfterRevision() == null || c.getBeforeRevision() == null) {
            return false;
        }
        return c.isIsReplaced() || c.isMoved() || c.isRenamed() || !Comparing.equal((Object)c.getBeforeRevision().getFile(), (Object)c.getAfterRevision().getFile());
    }
}

