/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnMergeInfoRootPanelManual;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoHolder {
    private final DecoratorManager myManager;
    private final SvnMergeInfoCache myMergeInfoCache;
    private final RootsAndBranches myMainPanel;
    private final SvnMergeInfoRootPanelManual myPanel;
    private final Map<Couple<String>, MergeInfoCached> myCachedMap;

    public MergeInfoHolder(Project project, DecoratorManager manager, RootsAndBranches mainPanel, SvnMergeInfoRootPanelManual panel) {
        this.myManager = manager;
        this.myMainPanel = mainPanel;
        this.myPanel = panel;
        this.myMergeInfoCache = SvnMergeInfoCache.getInstance(project);
        this.myCachedMap = ContainerUtil.newHashMap();
    }

    private MergeInfoCached getCurrentCache() {
        return this.myCachedMap.get(MergeInfoHolder.createKey(this.myPanel.getWcInfo(), this.myPanel.getBranch()));
    }

    private boolean isEnabledAndConfigured(boolean ignoreEnabled) {
        return (ignoreEnabled || this.myMainPanel.isHighlightingOn() && this.myPanel.isEnabled()) && this.myPanel.getBranch() != null && this.myPanel.getLocalBranch() != null;
    }

    public boolean refreshEnabled(boolean ignoreEnabled) {
        return this.isEnabledAndConfigured(ignoreEnabled) && this.getCurrentCache() == null;
    }

    private static Couple<String> createKey(WCInfoWithBranches root, WCInfoWithBranches.Branch branch) {
        return Couple.of((Object)root.getPath(), (Object)branch.getUrl());
    }

    public ListMergeStatus refresh(boolean ignoreEnabled) {
        CommittedChangeListsListener refresher = this.createRefresher(ignoreEnabled);
        if (refresher != null) {
            this.myManager.reportLoadedLists(refresher);
        }
        this.myManager.repaintTree();
        return ListMergeStatus.REFRESHING;
    }

    public CommittedChangeListsListener createRefresher(boolean ignoreEnabled) {
        MyRefresher result = null;
        if (this.refreshEnabled(ignoreEnabled)) {
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            this.myCachedMap.put(MergeInfoHolder.createKey(this.myPanel.getWcInfo(), this.myPanel.getBranch()), state != null ? state.copy() : new MergeInfoCached());
            this.myMergeInfoCache.clear(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = new MyRefresher();
        }
        return result;
    }

    public ListMergeStatus check(CommittedChangeList list, boolean ignoreEnabled) {
        ListMergeStatus result;
        if (!this.isEnabledAndConfigured(ignoreEnabled) || !(list instanceof SvnChangeList)) {
            result = ListMergeStatus.ALIEN;
        } else {
            MergeInfoCached cachedState = this.getCurrentCache();
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = cachedState != null ? this.check(list, cachedState, true) : (state != null ? this.check(list, state, false) : this.refresh(ignoreEnabled));
        }
        return result;
    }

    public ListMergeStatus check(CommittedChangeList list, MergeInfoCached state, boolean isCached) {
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = state.getMap().get(list.getNumber());
        ListMergeStatus result = state.copiedAfter(list) ? ListMergeStatus.COMMON : ListMergeStatus.from(mergeCheckResult);
        return (ListMergeStatus)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)(isCached ? ListMergeStatus.REFRESHING : ListMergeStatus.ALIEN))));
    }

    public void updateMixedRevisionsForPanel() {
        this.myPanel.setMixedRevisions(this.myMergeInfoCache.isMixedRevisions(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch()));
    }

    private class MyRefresher
    implements CommittedChangeListsListener {
        private final WCInfoWithBranches myRefreshedRoot;
        private final WCInfoWithBranches.Branch myRefreshedBranch;
        private final String myBranchPath;

        private MyRefresher() {
            this.myRefreshedRoot = MergeInfoHolder.this.myPanel.getWcInfo();
            this.myRefreshedBranch = MergeInfoHolder.this.myPanel.getBranch();
            this.myBranchPath = MergeInfoHolder.this.myPanel.getLocalBranch();
        }

        public void onBeforeStartReport() {
        }

        public boolean report(CommittedChangeList list) {
            if (list instanceof SvnChangeList) {
                final SvnMergeInfoCache.MergeCheckResult checkState = MergeInfoHolder.this.myMergeInfoCache.getState(this.myRefreshedRoot, (SvnChangeList)list, this.myRefreshedBranch, this.myBranchPath);
                final long number = list.getNumber();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MergeInfoCached cachedState = (MergeInfoCached)MergeInfoHolder.this.myCachedMap.get(MergeInfoHolder.createKey(MyRefresher.this.myRefreshedRoot, MyRefresher.this.myRefreshedBranch));
                        if (cachedState != null) {
                            cachedState.getMap().put(number, checkState);
                        }
                        MergeInfoHolder.this.myManager.repaintTree();
                    }
                });
            }
            return true;
        }

        public void onAfterEndReport() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MergeInfoHolder.this.myCachedMap.remove(MergeInfoHolder.createKey(MyRefresher.this.myRefreshedRoot, MyRefresher.this.myRefreshedBranch));
                    MergeInfoHolder.this.updateMixedRevisionsForPanel();
                    MergeInfoHolder.this.myManager.repaintTree();
                }
            });
        }
    }
}

