/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import icons.SvnIcons;
import javax.swing.Icon;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public enum ListMergeStatus {
    COMMON(SvnIcons.Common),
    MERGED(SvnIcons.Integrated),
    NOT_MERGED(SvnIcons.Notintegrated),
    ALIEN(null),
    REFRESHING(SvnIcons.IntegrationStatusUnknown);

    private final Icon myIcon;

    private ListMergeStatus(Icon icon) {
        this.myIcon = icon;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public static ListMergeStatus from(SvnMergeInfoCache.MergeCheckResult mergeCheckResult) {
        ListMergeStatus result = null;
        if (mergeCheckResult != null) {
            switch (mergeCheckResult) {
                case MERGED: {
                    result = MERGED;
                    break;
                }
                case COMMON: {
                    result = COMMON;
                    break;
                }
                default: {
                    result = NOT_MERGED;
                }
            }
        }
        return result;
    }
}

