/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.lock.LockClient;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnKitLockClient
extends BaseSvnClient
implements LockClient {
    @Override
    public void lock(File file, boolean force, String message, ProgressTracker handler) throws VcsException {
        try {
            this.getClient(handler).doLock(new File[]{file}, force, message);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void unlock(File file, boolean force, ProgressTracker handler) throws VcsException {
        try {
            this.getClient(handler).doUnlock(new File[]{file}, force);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private SVNWCClient getClient(ProgressTracker handler) {
        SVNWCClient client = this.myVcs.getSvnKitManager().createWCClient();
        client.setEventHandler(SvnKitLockClient.toEventHandler(handler));
        return client;
    }
}

