/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.integrate.IntegratedSelectedOptionsDialog;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SvnIntegrateChangesActionPerformer
implements SelectBranchPopup.BranchSelectedCallback {
    private final SvnVcs myVcs;
    private final MergerFactory myMergerFactory;
    private final SVNURL myCurrentBranch;

    public SvnIntegrateChangesActionPerformer(Project project, SVNURL currentBranchUrl, MergerFactory mergerFactory) {
        this.myVcs = SvnVcs.getInstance(project);
        this.myCurrentBranch = currentBranchUrl;
        this.myMergerFactory = mergerFactory;
    }

    @Override
    public void branchSelected(Project project, SvnBranchConfigurationNew configuration, String url, long revision) {
        this.onBranchSelected(url, null, null);
    }

    public void onBranchSelected(String url, String selectedLocalBranchPath, String dialogTitle) {
        if (this.myCurrentBranch.toString().equals(url)) {
            SvnIntegrateChangesActionPerformer.showSameSourceAndTargetMessage();
        } else {
            Pair<WorkingCopyInfo, SVNURL> pair = this.selectWorkingCopy(url, selectedLocalBranchPath, dialogTitle);
            if (pair != null) {
                this.runIntegrate(url, (WorkingCopyInfo)pair.first, (SVNURL)pair.second);
            }
        }
    }

    private Pair<WorkingCopyInfo, SVNURL> selectWorkingCopy(String url, String selectedLocalBranchPath, String dialogTitle) {
        return IntegratedSelectedOptionsDialog.selectWorkingCopy(this.myVcs.getProject(), this.myCurrentBranch, url, true, selectedLocalBranchPath, dialogTitle);
    }

    private void runIntegrate(String url, WorkingCopyInfo workingCopy, SVNURL workingCopyUrl) {
        SVNURL sourceUrl = this.correctSourceUrl(url, workingCopyUrl.toString());
        if (sourceUrl != null) {
            SvnIntegrateChangesTask integrateTask = new SvnIntegrateChangesTask(this.myVcs, workingCopy, this.myMergerFactory, sourceUrl, SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]), this.myVcs.getSvnConfiguration().isMergeDryRun(), SVNPathUtil.tail((String)this.myCurrentBranch.toString()));
            integrateTask.queue();
        }
    }

    private SVNURL correctSourceUrl(String targetUrl, String realTargetUrl) {
        try {
            if (realTargetUrl.length() > targetUrl.length()) {
                if (realTargetUrl.startsWith(targetUrl)) {
                    return this.myCurrentBranch.appendPath(realTargetUrl.substring(targetUrl.length()), true);
                }
            } else if (realTargetUrl.equals(targetUrl)) {
                return this.myCurrentBranch;
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return null;
    }

    private static void showSameSourceAndTargetMessage() {
        Messages.showErrorDialog((String)SvnBundle.message("action.Subversion.integrate.changes.error.source.and.target.same.text", new Object[0]), (String)SvnBundle.message("action.Subversion.integrate.changes.messages.title", new Object[0]));
    }
}

