/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.tmatesoft.svn.core.SVNURL;

public class MergeTask
extends BaseMergeTask {
    private final MergerFactory myFactory;

    public MergeTask(MergeContext mergeContext, QuickMergeInteraction interaction, MergerFactory factory, String mergeTitle) {
        super(mergeContext, interaction, mergeTitle, Where.AWT);
        this.myFactory = factory;
    }

    public void run(ContinuationContext context) {
        SVNURL sourceUrl = this.parseSourceUrl(context);
        if (sourceUrl != null) {
            context.next(new TaskDescriptor[]{TaskDescriptor.createForBackgroundableTask((Task.Backgroundable)this.newIntegrateTask(sourceUrl))});
            boolean needRefresh = this.setupDefaultEmptyChangeListForMerge();
            if (needRefresh) {
                this.refreshChanges(context);
            }
        }
    }

    private SvnIntegrateChangesTask newIntegrateTask(SVNURL branchUrl) {
        return new SvnIntegrateChangesTask(this.myMergeContext.getVcs(), new WorkingCopyInfo(this.myMergeContext.getWcInfo().getPath(), true), this.myFactory, branchUrl, this.getName(), false, this.myMergeContext.getBranchName());
    }

    private boolean setupDefaultEmptyChangeListForMerge() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myMergeContext.getProject());
        int i = 0;
        boolean needRefresh = false;
        while (true) {
            String name;
            LocalChangeList changeList;
            if ((changeList = changeListManager.findChangeList(name = this.myMergeContext.getTitle() + (i > 0 ? " (" + i + ")" : ""))) == null) {
                changeListManager.setDefaultChangeList(changeListManager.addChangeList(name, null));
                needRefresh = true;
                break;
            }
            if (changeList.getChanges().isEmpty()) {
                if (changeList.isDefault()) break;
                changeListManager.setDefaultChangeList(changeList);
                needRefresh = true;
                break;
            }
            ++i;
        }
        return needRefresh;
    }

    private void refreshChanges(final ContinuationContext context) {
        context.suspend();
        ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                context.ping();
            }
        }, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE_NOT_AWT, "", ModalityState.NON_MODAL);
    }
}

