/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.Intersection;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.ShelveLocalChangesTask;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class LocalChangesPromptTask
extends BaseMergeTask {
    private final boolean myMergeAll;
    private final List<CommittedChangeList> myChangeListsToMerge;
    private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;

    public LocalChangesPromptTask(MergeContext mergeContext, QuickMergeInteraction interaction, boolean mergeAll, List<CommittedChangeList> changeListsToMerge, SvnBranchPointsCalculator.WrapperInvertor copyPoint) {
        super(mergeContext, interaction, "local changes intersection check", Where.AWT);
        this.myMergeAll = mergeAll;
        this.myChangeListsToMerge = changeListsToMerge;
        this.myCopyPoint = copyPoint;
    }

    private File getLocalPath(String repositoryRelativePath) {
        String absolutePath = SVNPathUtil.append((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)repositoryRelativePath);
        SvnBranchPointsCalculator.BranchCopyData wrapped = this.myCopyPoint.getWrapped();
        String sourceRelativePath = SVNPathUtil.getRelativePath((String)(this.myCopyPoint.isInvertedSense() ? wrapped.getSource() : wrapped.getTarget()), (String)absolutePath);
        return !StringUtil.isEmptyOrSpaces((String)sourceRelativePath) ? new File(this.myMergeContext.getWcInfo().getPath(), sourceRelativePath) : null;
    }

    public void run(ContinuationContext context) {
        Intersection intersection;
        List localChangeLists = ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).getChangeListsCopy();
        Intersection intersection2 = intersection = this.myMergeAll ? LocalChangesPromptTask.getAllChangesIntersection(localChangeLists) : this.getChangesIntersection(localChangeLists, this.myChangeListsToMerge);
        if (intersection != null && !intersection.getChangesSubset().isEmpty()) {
            this.processIntersection(context, intersection);
        }
    }

    private void processIntersection(ContinuationContext context, Intersection intersection) {
        switch (this.myInteraction.selectLocalChangesAction(this.myMergeAll)) {
            case shelve: {
                context.next(new TaskDescriptor[]{new ShelveLocalChangesTask(this.myMergeContext, this.myInteraction, intersection)});
                break;
            }
            case cancel: {
                context.cancelEverything();
                break;
            }
            case inspect: {
                Collection changes = intersection.getChangesSubset().values();
                this.myInteraction.showIntersectedLocalPaths(ContainerUtil.sorted((Collection)ChangesUtil.getPaths((Collection)changes), (Comparator)FilePathByPathComparator.getInstance()));
                context.cancelEverything();
            }
        }
    }

    private Intersection getChangesIntersection(List<LocalChangeList> localChangeLists, List<CommittedChangeList> changeListsToMerge) {
        Intersection result = null;
        if (!ContainerUtil.isEmpty(changeListsToMerge)) {
            final Set<FilePath> pathsToMerge = this.collectPaths(changeListsToMerge);
            result = LocalChangesPromptTask.getChangesIntersection(localChangeLists, new Condition<Change>(){

                public boolean value(Change change) {
                    return LocalChangesPromptTask.notNullAndInSet(ChangesUtil.getBeforePath((Change)change), pathsToMerge) || LocalChangesPromptTask.notNullAndInSet(ChangesUtil.getAfterPath((Change)change), pathsToMerge);
                }
            });
        }
        return result;
    }

    private Set<FilePath> collectPaths(List<CommittedChangeList> lists) {
        HashSet<FilePath> result = new HashSet<FilePath>();
        for (CommittedChangeList list : lists) {
            SvnChangeList svnList = (SvnChangeList)list;
            for (String path : svnList.getAffectedPaths()) {
                File localPath = this.getLocalPath(path);
                if (localPath == null) continue;
                result.add((FilePath)new FilePathImpl(localPath, false));
            }
        }
        return result;
    }

    private static Intersection getAllChangesIntersection(List<LocalChangeList> localChangeLists) {
        return LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)Conditions.alwaysTrue());
    }

    private static Intersection getChangesIntersection(List<LocalChangeList> changeLists, Condition<Change> filter) {
        Intersection result = new Intersection();
        for (LocalChangeList changeList : changeLists) {
            for (Change change : changeList.getChanges()) {
                if (!filter.value((Object)change)) continue;
                result.add(changeList.getName(), changeList.getComment(), change);
            }
        }
        return result;
    }

    private static boolean notNullAndInSet(FilePath path, Set<FilePath> items) {
        return path != null && items.contains(path);
    }
}

