/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;

public class LoadRecentBranchRevisions
extends TaskDescriptor {
    public static final String PROP_BUNCH_SIZE = "idea.svn.quick.merge.bunch.size";
    private static final int BUNCH_SIZE = 100;
    private int myBunchSize;
    private long myFirst;
    private boolean myLastLoaded;
    private OneShotMergeInfoHelper myHelper;
    private List<CommittedChangeList> myCommittedChangeLists;
    private final MergeContext myMergeContext;

    public LoadRecentBranchRevisions(MergeContext mergeContext, long first) {
        this(mergeContext, first, -1);
    }

    public LoadRecentBranchRevisions(MergeContext mergeContext, long first, int bunchSize) {
        super("Loading recent " + mergeContext.getBranchName() + " revisions", Where.POOLED);
        this.myMergeContext = mergeContext;
        this.myFirst = first;
        Integer testBunchSize = Integer.getInteger(PROP_BUNCH_SIZE);
        this.myBunchSize = testBunchSize != null ? testBunchSize : (bunchSize > 0 ? bunchSize : 100);
    }

    public boolean isLastLoaded() {
        return this.myLastLoaded;
    }

    public void run(ContinuationContext context) {
        List<Pair<SvnChangeList, LogHierarchyNode>> changeLists = null;
        try {
            changeLists = this.getChangeListsBefore(this.myFirst);
        }
        catch (VcsException e) {
            context.handleException((Exception)((Object)e), true);
        }
        if (changeLists != null) {
            this.initialize(context, changeLists);
        }
    }

    private List<Pair<SvnChangeList, LogHierarchyNode>> getChangeListsBefore(long revision) throws VcsException {
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        if (revision > 0L) {
            settings.CHANGE_BEFORE = String.valueOf(revision);
            settings.USE_CHANGE_BEFORE_FILTER = true;
        }
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ProgressManager.progress2((String)SvnBundle.message("progress.text2.collecting.history", this.myMergeContext.getSourceUrl() + (revision > 0L ? "@" + revision : "")));
        final ArrayList result = ContainerUtil.newArrayList();
        ((SvnCommittedChangesProvider)this.myMergeContext.getVcs().getCommittedChangesProvider()).getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.myMergeContext.getSourceUrl()), this.myBunchSize + (revision > 0L ? 2 : 1), new PairConsumer<SvnChangeList, LogHierarchyNode>(){

            public void consume(SvnChangeList svnList, LogHierarchyNode tree) {
                indicator.setText2(SvnBundle.message("progress.text2.processing.revision", svnList.getNumber()));
                result.add(Pair.create((Object)svnList, (Object)tree));
            }
        });
        return result;
    }

    private List<CommittedChangeList> getNotMergedChangeLists(List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        ArrayList result = ContainerUtil.newArrayList();
        for (Pair<SvnChangeList, LogHierarchyNode> pair : changeLists) {
            if (this.myFirst > 0L && this.myFirst == ((SvnChangeList)pair.getFirst()).getNumber()) continue;
            result.add(pair.getFirst());
        }
        return result;
    }

    private void initialize(ContinuationContext context, List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        this.myCommittedChangeLists = this.getNotMergedChangeLists(changeLists);
        try {
            this.myHelper = new OneShotMergeInfoHelper(this.myMergeContext);
            ProgressManager.progress2((String)"Calculating not merged revisions");
            this.myHelper.prepare();
        }
        catch (VcsException e) {
            context.handleException((Exception)((Object)e), true);
        }
        boolean bl = this.myLastLoaded = this.myCommittedChangeLists.size() < this.myBunchSize + 1;
        if (this.myCommittedChangeLists.size() > this.myBunchSize) {
            this.myCommittedChangeLists = this.myCommittedChangeLists.subList(0, this.myBunchSize);
        }
    }

    public OneShotMergeInfoHelper getHelper() {
        return this.myHelper;
    }

    public List<CommittedChangeList> getCommittedChangeLists() {
        return this.myCommittedChangeLists;
    }
}

