/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.MarkerVcsContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SvnRepositoryBinaryContentRevision;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnRepositoryContentRevision
implements ContentRevision,
MarkerVcsContentRevision {
    private final SvnVcs myVcs;
    private final String myPath;
    private final FilePath myFilePath;
    private final long myRevision;

    public SvnRepositoryContentRevision(SvnVcs vcs, FilePath remotePath, FilePath localPath, long revision) {
        this.myVcs = vcs;
        this.myPath = FileUtil.toSystemIndependentName((String)remotePath.getPath());
        this.myFilePath = localPath != null ? localPath : remotePath;
        this.myRevision = revision;
    }

    public String getContent() throws VcsException {
        try {
            this.myFilePath.hardRefresh();
            return ContentRevisionCache.getOrLoadAsString((Project)this.myVcs.getProject(), (FilePath)this.myFilePath, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, (Throwable2Computable)new Throwable2Computable<byte[], VcsException, IOException>(){

                public byte[] compute() throws VcsException, IOException {
                    return SvnRepositoryContentRevision.this.loadContent().toByteArray();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    protected ByteArrayOutputStream loadContent() throws VcsException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ContentLoader loader = new ContentLoader(this.myPath, buffer, this.myRevision);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, null);
        } else {
            loader.run();
        }
        Exception exception = loader.getException();
        if (exception != null) {
            throw new VcsException((Throwable)exception);
        }
        ContentRevisionCache.checkContentsSize((String)this.myPath, (long)buffer.size());
        return buffer;
    }

    public FilePath getFile() {
        return this.myFilePath;
    }

    public SvnRevisionNumber getRevisionNumber() {
        return new SvnRevisionNumber(SVNRevision.create((long)this.myRevision));
    }

    public static SvnRepositoryContentRevision create(SvnVcs vcs, String repositoryRoot, String path, FilePath localPath, long revision) {
        return SvnRepositoryContentRevision.create(vcs, SvnUtil.appendMultiParts(repositoryRoot, path), localPath, revision);
    }

    public static SvnRepositoryContentRevision create(SvnVcs vcs, String fullPath, FilePath localPath, long revision) {
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)fullPath, (boolean)false);
        return SvnRepositoryContentRevision.create(vcs, remotePath, localPath, revision);
    }

    public static SvnRepositoryContentRevision create(SvnVcs vcs, FilePath remotePath, FilePath localPath, long revision) {
        return remotePath.getFileType().isBinary() ? new SvnRepositoryBinaryContentRevision(vcs, remotePath, localPath, revision) : new SvnRepositoryContentRevision(vcs, remotePath, localPath, revision);
    }

    public String toString() {
        return this.myFilePath.getIOFile() + "#" + this.myRevision;
    }

    public String getFullPath() {
        return this.myPath;
    }

    public String getRelativePath(String repositoryUrl) {
        return SvnUtil.getRelativePath(repositoryUrl, this.myPath);
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }

    public SvnTarget toTarget() throws SvnBindException {
        return SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(this.getFullPath()), (SVNRevision)this.getRevisionNumber().getRevision());
    }

    private class ContentLoader
    implements Runnable {
        private final String myPath;
        private final long myRevision;
        private final OutputStream myDst;
        private Exception myException;

        public ContentLoader(String path, OutputStream dst, long revision) {
            this.myPath = path;
            this.myDst = dst;
            this.myRevision = revision;
        }

        public Exception getException() {
            return this.myException;
        }

        @Override
        public void run() {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.loading.contents", this.myPath));
                progress.setText2(SvnBundle.message("progress.text2.revision.information", this.myRevision));
            }
            try {
                SVNRevision revision = SVNRevision.create((long)this.myRevision);
                byte[] contents = SvnUtil.getFileContents(SvnRepositoryContentRevision.this.myVcs, SvnTarget.fromURL((SVNURL)SvnUtil.parseUrl(SvnRepositoryContentRevision.this.getFullPath())), revision, revision);
                this.myDst.write(contents);
            }
            catch (VcsException e) {
                this.myException = e;
            }
            catch (IOException e) {
                this.myException = e;
            }
        }
    }
}

