/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ArrayUtil;
import java.io.File;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitHistoryClient
extends BaseSvnClient
implements HistoryClient {
    @Override
    public void doLog(SvnTarget target, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String[] revisionProperties, LogEntryConsumer handler) throws VcsException {
        try {
            SVNLogClient client = this.myVcs.getSvnKitManager().createLogClient();
            if (target.isFile()) {
                client.doLog(new File[]{target.getFile()}, startRevision, endRevision, target.getPegRevision(), stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit, revisionProperties, SvnKitHistoryClient.toHandler(handler));
            } else {
                client.doLog(target.getURL(), ArrayUtil.EMPTY_STRING_ARRAY, target.getPegRevision(), startRevision, endRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit, revisionProperties, SvnKitHistoryClient.toHandler(handler));
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private static ISVNLogEntryHandler toHandler(final LogEntryConsumer handler) {
        ISVNLogEntryHandler result = null;
        if (handler != null) {
            result = new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    handler.consume(LogEntry.create(logEntry));
                }
            };
        }
        return result;
    }
}

