/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProvider;
import com.intellij.util.ThreeState;
import com.intellij.vcsUtil.UIVcsUtil;
import javax.swing.JComponent;

public class SvnPhantomChangeDiffRequestProvider
implements ChangeDiffRequestProvider {
    public ThreeState isEquals(Change change1, Change change2) {
        return ThreeState.UNSURE;
    }

    public boolean canCreate(Project project, Change change) {
        return change.isPhantom();
    }

    public DiffRequest process(ChangeDiffRequestProducer presentable, UserDataHolder context, ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        indicator.checkCanceled();
        return new SvnPhantomDiffRequest(presentable.getChange());
    }

    public static class SvnPhantomDiffTool
    implements FrameDiffTool {
        public String getName() {
            return "SVN phantom changes viewer";
        }

        public boolean canShow(DiffContext context, DiffRequest request) {
            return request instanceof SvnPhantomDiffRequest;
        }

        public FrameDiffTool.DiffViewer createComponent(DiffContext context, DiffRequest request) {
            return new FrameDiffTool.DiffViewer(){

                public JComponent getComponent() {
                    return UIVcsUtil.infoPanel((String)"Technical record", (String)"This change is recorded because its target file was deleted,\nand some parent directory was copied (or moved) into the new place.");
                }

                public JComponent getPreferredFocusedComponent() {
                    return null;
                }

                public FrameDiffTool.ToolbarComponents init() {
                    return new FrameDiffTool.ToolbarComponents();
                }

                public void dispose() {
                }
            };
        }
    }

    public static class SvnPhantomDiffRequest
    extends DiffRequest {
        private final Change myChange;

        public SvnPhantomDiffRequest(Change change) {
            this.myChange = change;
        }

        public String getTitle() {
            return ChangeDiffRequestProducer.getRequestTitle((Change)this.myChange);
        }
    }
}

