/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.actions.diff.FileAwareDocumentContent;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.diff.ElementWithBranchComparer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class FileWithBranchComparer
extends ElementWithBranchComparer {
    private final Ref<byte[]> content = new Ref();
    private final StringBuilder remoteTitleBuilder = new StringBuilder();
    private final Ref<Boolean> success = new Ref();

    public FileWithBranchComparer(Project project, VirtualFile virtualFile, String branchUrl, long branchRevision) {
        super(project, virtualFile, branchUrl, branchRevision);
    }

    @Override
    protected void beforeCompare() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
    }

    @Override
    protected void compare() throws SVNException, VcsException {
        this.remoteTitleBuilder.append(this.myElementUrl);
        this.content.set((Object)SvnUtil.getFileContents(this.myVcs, SvnTarget.fromURL((SVNURL)this.myElementUrl), SVNRevision.HEAD, SVNRevision.UNDEFINED));
        this.success.set((Object)true);
    }

    @Override
    protected void showResult() {
        if (!this.success.isNull()) {
            String title = SvnBundle.message("compare.with.branch.diff.title", new Object[0]);
            String title1 = this.remoteTitleBuilder.toString();
            String title2 = this.myVirtualFile.getPresentableUrl();
            String contentText = CharsetToolkit.bytesToString((byte[])((byte[])this.content.get()), (Charset)this.myVirtualFile.getCharset());
            DiffContent content1 = FileAwareDocumentContent.create((Project)this.myProject, (String)contentText, (VirtualFile)this.myVirtualFile);
            DiffContent content2 = DiffContentFactory.getInstance().create(this.myProject, this.myVirtualFile);
            SimpleDiffRequest request = new SimpleDiffRequest(title, content1, content2, title1, title2);
            DiffManager.getInstance().showDiff(this.myProject, (DiffRequest)request);
        }
    }

    @Override
    public String getTitle() {
        return SvnBundle.message("compare.with.branch.progress.loading.content", new Object[0]);
    }
}

