/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import java.util.List;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public abstract class Loader {
    protected final SvnRepositoryCache myCache;

    protected Loader(SvnRepositoryCache cache) {
        this.myCache = cache;
    }

    public abstract void load(RepositoryTreeNode var1, Expander var2);

    protected abstract NodeLoadState getNodeLoadState();

    protected void refreshNodeError(RepositoryTreeNode node, String text) {
        RepositoryTreeNode existingNode = Loader.findExistingNode(node);
        if (existingNode != null) {
            existingNode.setErrorNode(text);
        }
    }

    protected void refreshNode(RepositoryTreeNode node, List<DirectoryEntry> data, Expander expander) {
        RepositoryTreeNode existingNode = Loader.findExistingNode(node);
        if (existingNode != null) {
            expander.onBeforeRefresh(existingNode);
            existingNode.setChildren(data, this.getNodeLoadState());
            expander.onAfterRefresh(existingNode);
        }
    }

    private static RepositoryTreeNode findExistingNode(RepositoryTreeNode node) {
        RepositoryTreeNode result = null;
        if (!node.isDisposed()) {
            result = node.getNodeWithSamePathUnderModelRoot();
        }
        return result == null || result.isDisposed() ? null : result;
    }
}

