/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class WCInfo {
    private final boolean myIsWcRoot;
    private final Depth myStickyDepth;
    private final RootUrlInfo myRootInfo;

    public WCInfo(RootUrlInfo rootInfo, boolean isWcRoot, Depth stickyDepth) {
        this.myRootInfo = rootInfo;
        this.myIsWcRoot = isWcRoot;
        this.myStickyDepth = stickyDepth;
    }

    public Depth getStickyDepth() {
        return this.myStickyDepth;
    }

    public String getPath() {
        return this.myRootInfo.getPath();
    }

    public VirtualFile getVcsRoot() {
        return null;
    }

    public SVNURL getUrl() {
        return this.myRootInfo.getAbsoluteUrlAsUrl();
    }

    public String getRootUrl() {
        return this.getUrl().toString();
    }

    public String getRepoUrl() {
        return this.getRepositoryRoot();
    }

    public RootUrlInfo getRootInfo() {
        return this.myRootInfo;
    }

    public boolean hasError() {
        return this.getRootInfo().getNode().hasError();
    }

    public String getErrorMessage() {
        SvnBindException error = this.getRootInfo().getNode().getError();
        return error != null ? error.getMessage() : "";
    }

    public WorkingCopyFormat getFormat() {
        return this.myRootInfo.getFormat();
    }

    public String getRepositoryRoot() {
        return this.myRootInfo.getRepositoryUrl();
    }

    public boolean isIsWcRoot() {
        return this.myIsWcRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WCInfo)) {
            return false;
        }
        WCInfo wcInfo = (WCInfo)o;
        return this.getPath().equals(wcInfo.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public NestedCopyType getType() {
        return this.myRootInfo.getType();
    }
}

