/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.copy;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.checkin.CmdCheckinClient;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdCopyMoveClient
extends BaseSvnClient
implements CopyMoveClient {
    @Override
    public void copy(File src, File dst, boolean makeParents, boolean isMove) throws VcsException {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, src);
        CommandUtil.put(parameters, dst, false);
        CommandUtil.put(parameters, makeParents, "--parents");
        File workingDirectory = isMove && !SystemInfo.isFileSystemCaseSensitive && FileUtil.filesEqual((File)src, (File)dst) ? CommandUtil.getHomeDirectory() : null;
        this.execute(this.myVcs, SvnTarget.fromFile((File)dst), workingDirectory, CmdCopyMoveClient.getCommandName(isMove), parameters, null);
    }

    @Override
    public long copy(SvnTarget source, SvnTarget destination, SVNRevision revision, boolean makeParents, boolean isMove, String message, CommitEventHandler handler) throws VcsException {
        if (!destination.isURL()) {
            throw new IllegalArgumentException("Only urls are supported as destination " + destination);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, makeParents, "--parents");
        parameters.add("--message");
        parameters.add(message);
        CmdCheckinClient.CommandListener listener = new CmdCheckinClient.CommandListener(handler);
        if (source.isFile()) {
            listener.setBaseDirectory(source.getFile());
        }
        this.execute(this.myVcs, source, CmdCopyMoveClient.getCommandName(isMove), parameters, (LineCommandListener)listener);
        return listener.getCommittedRevision();
    }

    @Override
    public void copy(SvnTarget source, File destination, SVNRevision revision, boolean makeParents, ProgressTracker handler) throws VcsException {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, makeParents, "--parents");
        File workingDirectory = CommandUtil.getHomeDirectory();
        BaseUpdateCommandListener listener = new BaseUpdateCommandListener(workingDirectory, handler);
        this.execute(this.myVcs, source, workingDirectory, SvnCommandName.copy, parameters, listener);
        listener.throwWrappedIfException();
    }

    private static SvnCommandName getCommandName(boolean isMove) {
        return isMove ? SvnCommandName.move : SvnCommandName.copy;
    }
}

