/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;

public enum ConflictReason {
    EDITED("edit", "edited"),
    OBSTRUCTED("obstruction", "obstruct", "obstructed"),
    DELETED("delete", "deleted"),
    MISSING("missing", "miss"),
    UNVERSIONED("unversioned", "unversion"),
    ADDED("add", "added"),
    REPLACED("replace", "replaced"),
    MOVED_AWAY("moved-away", new String[0]),
    MOVED_HERE("moved-here", new String[0]);

    private static final Map<String, ConflictReason> ourAllReasons;
    private final String myKey;
    private final String[] myOtherKeys;

    private ConflictReason(String key, String ... otherKeys) {
        this.myKey = key;
        this.myOtherKeys = otherKeys;
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(ConflictReason reason) {
        ourAllReasons.put(reason.myKey, reason);
        for (String key : reason.myOtherKeys) {
            ourAllReasons.put(key, reason);
        }
    }

    public static ConflictReason from(String reasonName) {
        ConflictReason result = ourAllReasons.get(reasonName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown conflict reason " + reasonName);
        }
        return result;
    }

    static {
        ourAllReasons = ContainerUtil.newHashMap();
        for (ConflictReason reason : ConflictReason.values()) {
            ConflictReason.register(reason);
        }
    }
}

