/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;

public class WinTerminalProcessHandler
extends TerminalProcessHandler {
    private static final String NON_CSI_ESCAPE_CODE = "\u001b.[@-_]";
    private static final String CSI_ESCAPE_CODE = "\u001b\\[(.*?)[@-~]";

    public WinTerminalProcessHandler(Process process, boolean forceUtf8, boolean forceBinary) {
        super(process, forceUtf8, forceBinary);
    }

    @Override
    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @Override
    protected String filterCombinedText(String currentLine) {
        return WinTerminalProcessHandler.removeAllBeforeCaretReturn(currentLine);
    }

    @Override
    protected String filterText(String text) {
        text = text.replaceAll(CSI_ESCAPE_CODE, "").replaceAll(NON_CSI_ESCAPE_CODE, "");
        text = StringUtil.trimLeading((String)text, (char)'\r');
        return text;
    }

    @Override
    protected Key resolveOutputType(String line, Key outputType) {
        return outputType;
    }

    private static String removeAllBeforeCaretReturn(String line) {
        int caretReturn = line.lastIndexOf("\r");
        while (caretReturn >= 0) {
            if (caretReturn + 1 < line.length() && line.charAt(caretReturn + 1) != '\n') {
                line = line.substring(caretReturn + 1);
                break;
            }
            caretReturn = line.lastIndexOf("\r", caretReturn - 1);
        }
        return line;
    }
}

