/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;

public class SvnProcessHandler
extends OSProcessHandler {
    private final boolean myForceUtf8;
    private final boolean myForceBinary;
    private final ByteArrayOutputStream myBinaryOutput;

    public SvnProcessHandler(Process process, boolean forceUtf8, boolean forceBinary) {
        this(process, null, forceUtf8, forceBinary);
    }

    public SvnProcessHandler(Process process, String commandLine, boolean forceUtf8, boolean forceBinary) {
        super(process, commandLine);
        this.myForceUtf8 = forceUtf8;
        this.myForceBinary = forceBinary;
        this.myBinaryOutput = new ByteArrayOutputStream();
    }

    public ByteArrayOutputStream getBinaryOutput() {
        return this.myBinaryOutput;
    }

    public Charset getCharset() {
        return this.myForceUtf8 ? CharsetToolkit.UTF8_CHARSET : super.getCharset();
    }

    protected BaseDataReader createOutputDataReader(BaseDataReader.SleepingPolicy sleepingPolicy) {
        if (this.myForceBinary) {
            return new SimpleBinaryOutputReader(this.myProcess.getInputStream(), sleepingPolicy);
        }
        return super.createOutputDataReader(sleepingPolicy);
    }

    private class SimpleBinaryOutputReader
    extends BinaryOutputReader {
        public SimpleBinaryOutputReader(InputStream stream, BaseDataReader.SleepingPolicy sleepingPolicy) {
            super(stream, sleepingPolicy);
            this.start();
        }

        protected void onBinaryAvailable(byte[] data, int size) {
            SvnProcessHandler.this.myBinaryOutput.write(data, 0, size);
        }

        protected Future<?> executeOnPooledThread(Runnable runnable) {
            return SvnProcessHandler.this.executeOnPooledThread(runnable);
        }
    }
}

