/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.UpdateOutputLineConverter;
import org.tmatesoft.svn.core.SVNException;

public class BaseUpdateCommandListener
extends LineCommandAdapter {
    private final UpdateOutputLineConverter converter;
    private final ProgressTracker handler;
    private final AtomicReference<SVNException> exception;

    public BaseUpdateCommandListener(File base, ProgressTracker handler) {
        this.handler = handler;
        this.converter = new UpdateOutputLineConverter(base);
        this.exception = new AtomicReference();
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        ProgressEvent event;
        if (ProcessOutputTypes.STDOUT.equals((Object)outputType) && (event = this.converter.convert(line)) != null) {
            this.beforeHandler(event);
            try {
                this.callHandler(event);
            }
            catch (SVNException e) {
                this.cancel();
                this.exception.set(e);
            }
        }
    }

    private void callHandler(ProgressEvent event) throws SVNException {
        if (this.handler != null) {
            this.handler.consume(event);
        }
    }

    public void throwWrappedIfException() throws SvnBindException {
        SVNException e = this.exception.get();
        if (e != null) {
            throw new SvnBindException(e);
        }
    }

    protected void beforeHandler(ProgressEvent event) {
    }
}

