/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.tmatesoft.svn.core.SVNErrorMessage;

public class CommitInfo {
    public static final CommitInfo EMPTY = new Builder().setRevision(-1L).build();
    private final long myRevision;
    private final Date myDate;
    private final String myAuthor;
    private final SVNErrorMessage myErrorMessage;

    private CommitInfo(Builder builder) {
        this.myRevision = builder.revision;
        this.myAuthor = builder.author;
        this.myDate = builder.date;
        this.myErrorMessage = builder.error;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getDate() {
        return this.myDate;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="commit")
    @XmlRootElement(name="commit")
    public static class Builder {
        @XmlAttribute(name="revision")
        private long revision;
        @XmlElement(name="author")
        private String author;
        @XmlElement(name="date")
        private Date date;
        private SVNErrorMessage error;

        public Builder() {
        }

        public Builder(long revision, Date date, String author) {
            this.revision = revision;
            this.date = date;
            this.author = author;
        }

        public long getRevision() {
            return this.revision;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public Builder setRevision(long revision) {
            this.revision = revision;
            return this;
        }

        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        public Builder setError(SVNErrorMessage error) {
            this.error = error;
            return this;
        }

        public CommitInfo build() {
            return new CommitInfo(this);
        }
    }
}

