/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class DefaultBranchConfigInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(DefaultBranchConfigInitializer.class);
    private static final String DEFAULT_TRUNK_NAME = "trunk";
    private static final String DEFAULT_BRANCHES_NAME = "branches";
    private static final String DEFAULT_TAGS_NAME = "tags";
    private final Project myProject;
    private final NewRootBunch myBunch;
    private final VirtualFile myRoot;

    public DefaultBranchConfigInitializer(Project project, NewRootBunch bunch, VirtualFile root) {
        this.myProject = project;
        this.myRoot = root;
        this.myBunch = bunch;
    }

    @Override
    public void run() {
        SvnBranchConfigurationNew configuration = this.getDefaultConfiguration();
        if (configuration != null) {
            for (String url : configuration.getBranchUrls()) {
                this.myBunch.reloadBranchesAsync(this.myRoot, url, InfoReliability.defaultValues);
            }
            this.myBunch.updateForRoot(this.myRoot, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.defaultValues), false);
        }
    }

    public SvnBranchConfigurationNew getDefaultConfiguration() {
        SvnBranchConfigurationNew result = null;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        SVNURL rootUrl = SvnUtil.getUrl(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myRoot));
        if (rootUrl != null) {
            try {
                result = DefaultBranchConfigInitializer.getDefaultConfiguration(vcs, rootUrl);
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            LOG.info("Directory is not a working copy: " + this.myRoot.getPresentableUrl());
        }
        return result;
    }

    private static SvnBranchConfigurationNew getDefaultConfiguration(SvnVcs vcs, SVNURL url) throws SVNException, VcsException {
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.setTrunkUrl(url.toString());
        SVNURL branchLocationsParent = DefaultBranchConfigInitializer.getBranchLocationsParent(url);
        if (branchLocationsParent != null) {
            SvnTarget target = SvnTarget.fromURL((SVNURL)branchLocationsParent);
            vcs.getFactory(target).createBrowseClient().list(target, SVNRevision.HEAD, Depth.IMMEDIATES, DefaultBranchConfigInitializer.createHandler(result, target.getURL()));
        }
        return result;
    }

    private static SVNURL getBranchLocationsParent(SVNURL url) throws SVNException {
        while (!DefaultBranchConfigInitializer.hasEmptyName(url) && !DefaultBranchConfigInitializer.hasDefaultName(url)) {
            url = url.removePathTail();
        }
        return DefaultBranchConfigInitializer.hasDefaultName(url) ? url.removePathTail() : null;
    }

    private static boolean hasEmptyName(SVNURL url) {
        return StringUtil.isEmpty((String)SVNPathUtil.tail((String)url.getPath()));
    }

    private static boolean hasDefaultName(SVNURL url) {
        String name = SVNPathUtil.tail((String)url.getPath());
        return name.equalsIgnoreCase(DEFAULT_TRUNK_NAME) || name.equalsIgnoreCase(DEFAULT_BRANCHES_NAME) || name.equalsIgnoreCase(DEFAULT_TAGS_NAME);
    }

    private static DirectoryEntryConsumer createHandler(final SvnBranchConfigurationNew result, final SVNURL rootPath) {
        return new DirectoryEntryConsumer(){

            public void consume(DirectoryEntry entry) throws SVNException {
                if (entry.isDirectory()) {
                    SVNURL childUrl = rootPath.appendPath(entry.getName(), false);
                    if (StringUtil.endsWithIgnoreCase((String)entry.getName(), (String)DefaultBranchConfigInitializer.DEFAULT_TRUNK_NAME)) {
                        result.setTrunkUrl(childUrl.toString());
                    } else {
                        result.addBranches(childUrl.toString(), new InfoStorage<List<SvnBranchItem>>(new ArrayList(0), InfoReliability.defaultValues));
                    }
                }
            }
        };
    }
}

