/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FileStatus;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.status.PortableStatus;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnStatusConvertor {
    private SvnStatusConvertor() {
    }

    public static FileStatus convertStatus(StatusType itemStatus, StatusType propertiesStatus) {
        PortableStatus status = new PortableStatus();
        status.setContentsStatus(itemStatus);
        status.setPropertiesStatus(propertiesStatus);
        return SvnStatusConvertor.convertStatus(status);
    }

    public static FileStatus convertStatus(Status status) {
        if (status == null) {
            return FileStatus.UNKNOWN;
        }
        if (status.is(StatusType.STATUS_UNVERSIONED)) {
            return FileStatus.UNKNOWN;
        }
        if (status.is(StatusType.STATUS_MISSING)) {
            return FileStatus.DELETED_FROM_FS;
        }
        if (status.is(StatusType.STATUS_EXTERNAL)) {
            return SvnFileStatus.EXTERNAL;
        }
        if (status.is(StatusType.STATUS_OBSTRUCTED)) {
            return SvnFileStatus.OBSTRUCTED;
        }
        if (status.is(StatusType.STATUS_IGNORED)) {
            return FileStatus.IGNORED;
        }
        if (status.is(StatusType.STATUS_ADDED)) {
            return FileStatus.ADDED;
        }
        if (status.is(StatusType.STATUS_DELETED)) {
            return FileStatus.DELETED;
        }
        if (status.is(StatusType.STATUS_REPLACED)) {
            return SvnFileStatus.REPLACED;
        }
        if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED || status.getPropertiesStatus() == StatusType.STATUS_CONFLICTED) {
            if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED && status.getPropertiesStatus() == StatusType.STATUS_CONFLICTED) {
                return FileStatus.MERGED_WITH_BOTH_CONFLICTS;
            }
            if (status.getContentsStatus() == StatusType.STATUS_CONFLICTED) {
                return FileStatus.MERGED_WITH_CONFLICTS;
            }
            return FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
        }
        if (status.getContentsStatus() == StatusType.STATUS_MODIFIED || status.getPropertiesStatus() == StatusType.STATUS_MODIFIED) {
            return FileStatus.MODIFIED;
        }
        if (status.isSwitched()) {
            return FileStatus.SWITCHED;
        }
        if (status.isCopied()) {
            return FileStatus.ADDED;
        }
        return FileStatus.NOT_CHANGED;
    }

    public static FileStatus convertPropertyStatus(StatusType status) {
        if (status == null) {
            return FileStatus.UNKNOWN;
        }
        if (StatusType.STATUS_UNVERSIONED.equals((Object)status)) {
            return FileStatus.UNKNOWN;
        }
        if (StatusType.STATUS_MISSING.equals((Object)status)) {
            return FileStatus.DELETED_FROM_FS;
        }
        if (StatusType.STATUS_EXTERNAL.equals((Object)status)) {
            return SvnFileStatus.EXTERNAL;
        }
        if (StatusType.STATUS_OBSTRUCTED.equals((Object)status)) {
            return SvnFileStatus.OBSTRUCTED;
        }
        if (StatusType.STATUS_IGNORED.equals((Object)status)) {
            return FileStatus.IGNORED;
        }
        if (StatusType.STATUS_ADDED.equals((Object)status)) {
            return FileStatus.ADDED;
        }
        if (StatusType.STATUS_DELETED.equals((Object)status)) {
            return FileStatus.DELETED;
        }
        if (StatusType.STATUS_REPLACED.equals((Object)status)) {
            return SvnFileStatus.REPLACED;
        }
        if (status == StatusType.STATUS_CONFLICTED) {
            return FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
        }
        if (status == StatusType.STATUS_MODIFIED) {
            return FileStatus.MODIFIED;
        }
        return FileStatus.NOT_CHANGED;
    }
}

