/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.idea.svn.SvnConfiguration;

public final class SvnOptionsTopHitProvider
extends OptionsTopHitProvider {
    public String getId() {
        return "vcs";
    }

    public Collection<BooleanOptionDescription> getOptions(Project project) {
        if (project != null) {
            for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)project).getAllVcss()) {
                if (!"Subversion".equals(descriptor.getDisplayName())) continue;
                SvnConfiguration config = SvnConfiguration.getInstance(project);
                return Collections.unmodifiableCollection(Arrays.asList(SvnOptionsTopHitProvider.option(config, "Subversion: Update administrative information only in changed subtrees", "isUpdateLockOnDemand", "setUpdateLockOnDemand"), SvnOptionsTopHitProvider.option(config, "Subversion: Check svn:mergeinfo in target subtree when preparing for merge", "isCheckNestedForQuickMerge", "setCheckNestedForQuickMerge"), SvnOptionsTopHitProvider.option(config, "Subversion: Show merge source in history and annotations", "isShowMergeSourcesInAnnotate", "setShowMergeSourcesInAnnotate"), SvnOptionsTopHitProvider.option(config, "Subversion: Ignore whitespace differences in annotations", "isIgnoreSpacesInAnnotate", "setIgnoreSpacesInAnnotate"), SvnOptionsTopHitProvider.option(config, "Subversion: Use IDEA general proxy settings as default for Subversion", "isIsUseDefaultProxy", "setIsUseDefaultProxy")));
            }
        }
        return Collections.emptyList();
    }

    private static BooleanOptionDescription option(final Object instance, String option, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option, "vcs.Subversion", getter, setter){

            public Object getInstance() {
                return instance;
            }
        };
    }
}

