/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.svn.SvnNativeCallsTranslator;

public class NativeLogReader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.NativeLogReader");
    private static final MultiMap<Thread, CallInfo> ourCallLog = new MultiMap<Thread, CallInfo>(){

        protected Collection<CallInfo> createCollection() {
            return new ArrayList<CallInfo>(2);
        }
    };
    private static final Set<Thread> ourTrackedThreads = Collections.synchronizedSet(new HashSet());
    private static final Object ourLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInfo(CallInfo callInfo) {
        Thread key;
        if (ourTrackedThreads.size() > 1000) {
            for (CallInfo info : ourCallLog.values()) {
                LOG.info(SvnNativeCallsTranslator.defaultMessage(info));
            }
            LOG.warn("Too many cached Subversion native calls. Log cleared.");
            ourTrackedThreads.clear();
        }
        if (ourTrackedThreads.contains(key = Thread.currentThread())) {
            Object object = ourLock;
            synchronized (object) {
                ourCallLog.putValue((Object)key, (Object)callInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Thread key = Thread.currentThread();
        if (ourTrackedThreads.contains(key)) {
            Object object = ourLock;
            synchronized (object) {
                ourCallLog.remove((Object)key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CallInfo> getLogged() {
        Thread key = Thread.currentThread();
        if (ourTrackedThreads.contains(key)) {
            Object object = ourLock;
            synchronized (object) {
                return (List)ourCallLog.get((Object)key);
            }
        }
        return Collections.emptyList();
    }

    public static void startTracking() {
        ourTrackedThreads.add(Thread.currentThread());
    }

    public static void endTracking() {
        ourTrackedThreads.remove(Thread.currentThread());
    }

    public static class CallInfo {
        private final String myFunctionName;
        private final int myResultCode;
        private final String myStrResultCode;

        public CallInfo(String functionName, int resultCode) {
            this.myFunctionName = functionName;
            this.myResultCode = resultCode;
            this.myStrResultCode = String.valueOf(resultCode);
        }

        public CallInfo(String functionName, String resultCode) {
            this.myFunctionName = functionName;
            this.myResultCode = 0;
            this.myStrResultCode = resultCode;
        }

        public String getFunctionName() {
            return this.myFunctionName;
        }

        public int getResultCode() {
            return this.myResultCode;
        }

        public String getStrResultCode() {
            return this.myStrResultCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallInfo info = (CallInfo)o;
            if (this.myResultCode != info.myResultCode) {
                return false;
            }
            if (!this.myFunctionName.equals(info.myFunctionName)) {
                return false;
            }
            return this.myStrResultCode.equals(info.myStrResultCode);
        }

        public int hashCode() {
            int result = this.myFunctionName.hashCode();
            result = 31 * result + this.myResultCode;
            result = 31 * result + this.myStrResultCode.hashCode();
            return result;
        }

        public String toString() {
            return "CallInfo{myFunctionName='" + this.myFunctionName + '\'' + ", myResultCode=" + this.myResultCode + ", myStrResultCode='" + this.myStrResultCode + '\'' + '}';
        }
    }
}

