/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class ForNestedRootChecker {
    private final SvnVcs myVcs;
    private final VcsRootIterator myRootIterator;

    public ForNestedRootChecker(SvnVcs vcs) {
        this.myVcs = vcs;
        this.myRootIterator = new VcsRootIterator(vcs.getProject(), (AbstractVcs)vcs);
    }

    public List<Node> getAllNestedWorkingCopies(VirtualFile root) {
        LinkedList result = ContainerUtil.newLinkedList();
        LinkedList workItems = ContainerUtil.newLinkedList();
        workItems.add(root);
        while (!workItems.isEmpty()) {
            VirtualFile item = (VirtualFile)workItems.removeFirst();
            this.checkCancelled();
            Node vcsElement = new VcsFileResolver(this.myVcs, item, root).resolve();
            if (vcsElement != null) {
                result.add(vcsElement);
                continue;
            }
            for (VirtualFile child : item.getChildren()) {
                this.checkCancelled();
                if (!child.isDirectory() || !this.myRootIterator.acceptFolderUnderVcs(root, child)) continue;
                workItems.add(child);
            }
        }
        return result;
    }

    private void checkCancelled() {
        if (this.myVcs.getProject().isDisposed()) {
            throw new ProcessCanceledException();
        }
    }

    private static class VcsFileResolver {
        private final SvnVcs myVcs;
        private final VirtualFile myFile;
        private final File myIoFile;
        private final VirtualFile myRoot;
        private Info myInfo;
        private SvnBindException myError;

        private VcsFileResolver(SvnVcs vcs, VirtualFile file, VirtualFile root) {
            this.myVcs = vcs;
            this.myFile = file;
            this.myIoFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            this.myRoot = root;
        }

        public Node resolve() {
            this.runInfo();
            return this.processInfo();
        }

        private void runInfo() {
            if (this.isRoot() || this.hasChildAdminDirectory()) {
                try {
                    this.myInfo = this.myVcs.getFactory(this.myIoFile, false).createInfoClient().doInfo(this.myIoFile, SVNRevision.UNDEFINED);
                }
                catch (SvnBindException e) {
                    this.myError = e;
                }
            }
        }

        private boolean isRoot() {
            return this.myRoot == this.myFile;
        }

        private boolean hasChildAdminDirectory() {
            return this.myFile.findChild(SvnUtil.SVN_ADMIN_DIR_NAME) != null;
        }

        private Node processInfo() {
            Node result = null;
            if (this.myError != null) {
                if (!SvnUtil.isUnversionedOrNotFound(this.myError)) {
                    result = new Node(this.myFile, this.getFakeUrl(), this.getFakeUrl(), this.myError);
                }
            } else if (this.myInfo != null && this.myInfo.getRepositoryRootURL() != null && this.myInfo.getURL() != null) {
                result = new Node(this.myFile, this.myInfo.getURL(), this.myInfo.getRepositoryRootURL());
            }
            return result;
        }

        private SVNURL getFakeUrl() {
            try {
                return SVNURL.fromFile((File)this.myIoFile);
            }
            catch (SVNException e) {
                throw SvnUtil.createIllegalArgument(e);
            }
        }
    }
}

