/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.resource.ExternalResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExternalResource
implements ExternalResource {
    protected abstract InputStream openStream() throws IOException;

    @Override
    public String getName() {
        return this.getURI().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(File destination) throws IOException {
        FileOutputStream output = new FileOutputStream(destination);
        try {
            this.writeTo(output);
        }
        finally {
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream output) throws IOException {
        InputStream input = this.openStream();
        try {
            IOUtils.copyLarge((InputStream)input, (OutputStream)output);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withContent(Action<? super InputStream> readAction) throws IOException {
        InputStream input = this.openStream();
        try {
            readAction.execute((Object)input);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withContent(Transformer<? extends T, ? super InputStream> readAction) throws IOException {
        InputStream input = this.openStream();
        try {
            Object object = readAction.transform((Object)input);
            return (T)object;
        }
        finally {
            input.close();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

