/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.rmi.RemoteException;
import org.codehaus.plexus.logging.Logger;
import org.jetbrains.idea.maven.server.MavenServerConsole;

public class MavenServerConsoleWrapper
implements Logger {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private MavenServerConsole myWrappee;
    private int myThreshold;

    void doPrint(int level, String message, Throwable throwable) {
        if (level < this.myThreshold) {
            return;
        }
        if (!message.endsWith(LINE_SEPARATOR)) {
            message = message + LINE_SEPARATOR;
        }
        if (this.myWrappee != null) {
            try {
                this.myWrappee.printMessage(level, message, throwable);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    public void setWrappee(MavenServerConsole wrappee) {
        this.myWrappee = wrappee;
    }

    public void debug(String string, Throwable throwable) {
        this.doPrint(0, string, throwable);
    }

    public void info(String string, Throwable throwable) {
        this.doPrint(1, string, throwable);
    }

    public void warn(String string, Throwable throwable) {
        this.doPrint(2, string, throwable);
    }

    public void error(String string, Throwable throwable) {
        this.doPrint(3, string, throwable);
    }

    public void fatalError(String string, Throwable throwable) {
        this.doPrint(4, string, throwable);
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public boolean isDebugEnabled() {
        return this.getThreshold() <= 0;
    }

    public void info(String message) {
        this.info(message, null);
    }

    public boolean isInfoEnabled() {
        return this.getThreshold() <= 1;
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public boolean isWarnEnabled() {
        return this.getThreshold() <= 2;
    }

    public void error(String message) {
        this.error(message, null);
    }

    public boolean isErrorEnabled() {
        return this.getThreshold() <= 3;
    }

    public void fatalError(String message) {
        this.fatalError(message, null);
    }

    public boolean isFatalErrorEnabled() {
        return this.getThreshold() <= 4;
    }

    public void setThreshold(int threshold) {
        this.myThreshold = threshold;
    }

    public int getThreshold() {
        return this.myThreshold;
    }

    public Logger getChildLogger(String s) {
        return null;
    }

    public String getName() {
        return this.toString();
    }
}

