/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.JiraVersion;
import com.intellij.tasks.jira.rest.JiraRestTask;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api20alpha1.JiraRestApi20Alpha1;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public abstract class JiraRestApi
extends JiraRemoteApi {
    private static final Logger LOG = Logger.getInstance(JiraRestApi.class);

    public static JiraRestApi fromJiraVersion(JiraVersion jiraVersion, JiraRepository repository) {
        if (jiraVersion.getMajorNumber() == 4 && jiraVersion.getMinorNumber() >= 2) {
            return new JiraRestApi20Alpha1(repository);
        }
        if (jiraVersion.getMajorNumber() >= 5) {
            return new JiraRestApi2(repository);
        }
        LOG.warn("JIRA below 4.2.0 doesn't support REST API (" + jiraVersion + " used)");
        return null;
    }

    public static JiraRestApi fromJiraVersion(String version, JiraRepository repository) {
        return JiraRestApi.fromJiraVersion(new JiraVersion(version), repository);
    }

    protected JiraRestApi(JiraRepository repository) {
        super(repository);
    }

    @Override
    public final List<Task> findTasks(String jql, int max) throws Exception {
        GetMethod method = this.getMultipleIssuesSearchMethod(jql, max);
        String response = this.myRepository.executeMethod((HttpMethod)method);
        List<JiraIssue> issues = this.parseIssues(response);
        return ContainerUtil.map(issues, (Function)new Function<JiraIssue, Task>(){

            public JiraRestTask fun(JiraIssue issue) {
                return new JiraRestTask(issue, (TaskRepository)JiraRestApi.this.myRepository);
            }
        });
    }

    @Override
    public final JiraRestTask findTask(String key) throws Exception {
        GetMethod method = this.getSingleIssueSearchMethod(key);
        try {
            return new JiraRestTask(this.parseIssue(this.myRepository.executeMethod((HttpMethod)method)), (TaskRepository)this.myRepository);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected GetMethod getSingleIssueSearchMethod(String key) {
        return new GetMethod(this.myRepository.getRestUrl("issue", key));
    }

    protected GetMethod getMultipleIssuesSearchMethod(String jql, int max) {
        GetMethod method = new GetMethod(this.myRepository.getRestUrl("search"));
        method.setQueryString(new NameValuePair[]{new NameValuePair("jql", jql), new NameValuePair("maxResults", String.valueOf(max))});
        return method;
    }

    protected abstract List<JiraIssue> parseIssues(String var1);

    protected abstract JiraIssue parseIssue(String var1);

    @Override
    public void setTaskState(Task task, CustomTaskState state) throws Exception {
        String requestBody = this.getRequestForStateTransition(state);
        LOG.debug(String.format("Transition: %s -> %s, request: %s", task.getState(), state, requestBody));
        PostMethod method = new PostMethod(this.myRepository.getRestUrl("issue", task.getId(), "transitions"));
        method.setRequestEntity(JiraRestApi.createJsonEntity(requestBody));
        this.myRepository.executeMethod((HttpMethod)method);
    }

    protected abstract String getRequestForStateTransition(CustomTaskState var1);

    protected static RequestEntity createJsonEntity(String requestBody) {
        try {
            return new StringRequestEntity(requestBody, "application/json", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 encoding is not supported");
        }
    }
}

