/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api20alpha1.JiraRestApi20Alpha1;
import com.intellij.tasks.jira.soap.JiraLegacyApi;
import java.util.List;
import java.util.Set;

public abstract class JiraRemoteApi {
    protected final JiraRepository myRepository;

    protected JiraRemoteApi(JiraRepository repository) {
        this.myRepository = repository;
    }

    public abstract List<Task> findTasks(String var1, int var2) throws Exception;

    public abstract Task findTask(String var1) throws Exception;

    public abstract Set<CustomTaskState> getAvailableTaskStates(Task var1) throws Exception;

    public abstract void setTaskState(Task var1, CustomTaskState var2) throws Exception;

    public abstract void updateTimeSpend(LocalTask var1, String var2, String var3) throws Exception;

    public final String getVersionName() {
        return this.getType().getVersionName();
    }

    public final String toString() {
        return "JiraRemoteApi(" + this.getType().getVersionName() + ")";
    }

    public abstract ApiType getType();

    public static enum ApiType {
        LEGACY("XML-RPC + RSS"){

            @Override
            public JiraLegacyApi createApi(JiraRepository repository) {
                return new JiraLegacyApi(repository);
            }
        }
        ,
        REST_2_0("REST 2.0"){

            @Override
            public JiraRestApi2 createApi(JiraRepository repository) {
                return new JiraRestApi2(repository);
            }
        }
        ,
        REST_2_0_ALPHA("REST 2.0.alpha1"){

            @Override
            public JiraRestApi20Alpha1 createApi(JiraRepository repository) {
                return new JiraRestApi20Alpha1(repository);
            }
        };

        private String myVersionName;

        private ApiType(String versionName) {
            this.myVersionName = versionName;
        }

        public abstract JiraRemoteApi createApi(JiraRepository var1);

        public String getVersionName() {
            return this.myVersionName;
        }
    }
}

