/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.serialize;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSerializerFactory {
    public static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    public static final Serializer<Long> LONG_SERIALIZER = new LongSerializer();
    public static final Serializer<File> FILE_SERIALIZER = new FileSerializer();
    public static final Serializer<byte[]> BYTE_ARRAY_SERIALIZER = new ByteArraySerializer();
    public static final Serializer<Map<String, String>> NO_NULL_STRING_MAP_SERIALIZER = new StringMapSerializer();

    public <T> Serializer<T> getSerializerFor(Class<T> type) {
        if (type.equals(String.class)) {
            return STRING_SERIALIZER;
        }
        if (type.equals(Long.class)) {
            return LONG_SERIALIZER;
        }
        if (type.equals(File.class)) {
            return FILE_SERIALIZER;
        }
        if (type.equals(byte[].class)) {
            return BYTE_ARRAY_SERIALIZER;
        }
        if (type.isEnum()) {
            return new EnumSerializer(type);
        }
        return new DefaultSerializer(type.getClassLoader());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringMapSerializer
    implements Serializer<Map<String, String>> {
        private StringMapSerializer() {
        }

        @Override
        public Map<String, String> read(Decoder decoder) throws Exception {
            int pairs = decoder.readSmallInt();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < pairs; ++i) {
                builder.put((Object)decoder.readString(), (Object)decoder.readString());
            }
            return builder.build();
        }

        @Override
        public void write(Encoder encoder, Map<String, String> value) throws Exception {
            encoder.writeSmallInt(value.size());
            for (Map.Entry<String, String> entry : value.entrySet()) {
                encoder.writeString(entry.getKey());
                encoder.writeString(entry.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteArraySerializer
    implements Serializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public byte[] read(Decoder decoder) throws Exception {
            return decoder.readBinary();
        }

        @Override
        public void write(Encoder encoder, byte[] value) throws Exception {
            encoder.writeBinary(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSerializer
    implements Serializer<File> {
        private FileSerializer() {
        }

        @Override
        public File read(Decoder decoder) throws Exception {
            return new File(decoder.readString());
        }

        @Override
        public void write(Encoder encoder, File value) throws Exception {
            encoder.writeString(value.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringSerializer
    implements Serializer<String> {
        private StringSerializer() {
        }

        @Override
        public String read(Decoder decoder) throws Exception {
            return decoder.readString();
        }

        @Override
        public void write(Encoder encoder, String value) throws Exception {
            encoder.writeString(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongSerializer
    implements Serializer<Long> {
        private LongSerializer() {
        }

        @Override
        public Long read(Decoder decoder) throws Exception {
            return decoder.readLong();
        }

        @Override
        public void write(Encoder encoder, Long value) throws Exception {
            encoder.writeLong(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumSerializer<T extends Enum>
    implements Serializer<T> {
        private final Class<T> type;

        private EnumSerializer(Class<T> type) {
            this.type = type;
        }

        @Override
        public T read(Decoder decoder) throws Exception {
            return (T)((Enum[])this.type.getEnumConstants())[decoder.readSmallInt()];
        }

        @Override
        public void write(Encoder encoder, T value) throws Exception {
            encoder.writeSmallInt((byte)((Enum)value).ordinal());
        }
    }
}

