/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import java.util.Date;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.messaging.dispatch.Receive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayedReceive<T>
implements Stoppable,
Receive<T> {
    private final TimeProvider timeProvider;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final PriorityQueue<DelayedMessage> queue = new PriorityQueue();
    private boolean stopping;

    public DelayedReceive(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T receive() {
        DelayedMessage message;
        this.lock.lock();
        try {
            while (true) {
                if ((message = this.queue.peek()) == null && this.stopping) {
                    T t = null;
                    return t;
                }
                if (message == null) {
                    this.condition.await();
                    continue;
                }
                long now = this.timeProvider.getCurrentTime();
                if (message.dispatchTime <= now) break;
                this.condition.awaitUntil(new Date(message.dispatchTime));
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        this.queue.poll();
        if (this.queue.isEmpty()) {
            this.condition.signalAll();
        }
        Object object = message.message;
        return (T)object;
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchLater(T message, int delayValue, TimeUnit delayUnits) {
        long dispatchTime = this.timeProvider.getCurrentTime() + delayUnits.toMillis(delayValue);
        this.lock.lock();
        try {
            if (this.stopping) {
                throw new IllegalStateException("This dispatch has been stopped.");
            }
            this.queue.add(new DelayedMessage(dispatchTime, message));
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T message) {
        this.lock.lock();
        try {
            Iterator<DelayedMessage> iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                DelayedMessage next = iterator.next();
                if (!next.message.equals(message)) continue;
                iterator.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        this.lock.lock();
        try {
            this.stopping = true;
            this.condition.signalAll();
            while (!this.queue.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelayedMessage
    implements Comparable<DelayedMessage> {
        private final long dispatchTime;
        private final T message;

        private DelayedMessage(long dispatchTime, T message) {
            this.dispatchTime = dispatchTime;
            this.message = message;
        }

        @Override
        public int compareTo(DelayedMessage delayedMessage) {
            if (this.dispatchTime > delayedMessage.dispatchTime) {
                return 1;
            }
            if (this.dispatchTime < delayedMessage.dispatchTime) {
                return -1;
            }
            return 0;
        }
    }
}

