/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import java.io.IOException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.git4idea.ssh.GitSSHHandler;

public class GitSSHXmlRpcClient
implements GitSSHHandler {
    private final XmlRpcClientLite myClient;

    GitSSHXmlRpcClient(int port, boolean batchMode) throws IOException {
        this.myClient = batchMode ? null : new XmlRpcClientLite("127.0.0.1", port);
    }

    @Override
    public boolean verifyServerHostKey(int handler, String hostname, int port, String serverHostKeyAlgorithm, String serverHostKey, boolean isNew) {
        if (this.myClient == null) {
            return false;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handler);
        parameters.add(hostname);
        parameters.add(port);
        parameters.add(serverHostKeyAlgorithm);
        parameters.add(serverHostKey);
        parameters.add(isNew);
        try {
            return (Boolean)this.myClient.execute(GitSSHXmlRpcClient.methodName("verifyServerHostKey"), parameters);
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    private static String methodName(String method) {
        return "Git4ideaSSHHandler." + method;
    }

    @Override
    public String askPassphrase(int handler, String username, String keyPath, boolean resetPassword, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handler);
        parameters.add(username);
        parameters.add(keyPath);
        parameters.add(resetPassword);
        parameters.add(lastError);
        try {
            return GitSSHXmlRpcClient.adjustNull((String)this.myClient.execute(GitSSHXmlRpcClient.methodName("askPassphrase"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    public Vector<String> replyToChallenge(int handlerNo, String username, String name, String instruction, int numPrompts, Vector<String> prompt, Vector<Boolean> echo, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handlerNo);
        parameters.add(username);
        parameters.add(name);
        parameters.add(instruction);
        parameters.add(numPrompts);
        parameters.add(prompt);
        parameters.add(echo);
        parameters.add(lastError);
        try {
            return GitSSHXmlRpcClient.adjustNull((Vector)this.myClient.execute(GitSSHXmlRpcClient.methodName("replyToChallenge"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    public String askPassword(int handlerNo, String username, boolean resetPassword, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handlerNo);
        parameters.add(username);
        parameters.add(resetPassword);
        parameters.add(lastError);
        try {
            return GitSSHXmlRpcClient.adjustNull((String)this.myClient.execute(GitSSHXmlRpcClient.methodName("askPassword"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    public String setLastSuccessful(int handlerNo, String userName, String method, String error) {
        if (this.myClient == null) {
            return "";
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handlerNo);
        parameters.add(userName);
        parameters.add(method);
        parameters.add(error);
        try {
            return (String)this.myClient.execute(GitSSHXmlRpcClient.methodName("setLastSuccessful"), parameters);
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    public String getLastSuccessful(int handlerNo, String userName) {
        if (this.myClient == null) {
            return "";
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handlerNo);
        parameters.add(userName);
        try {
            return (String)this.myClient.execute(GitSSHXmlRpcClient.methodName("getLastSuccessful"), parameters);
        }
        catch (XmlRpcException e) {
            GitSSHXmlRpcClient.log("getLastSuccessful failed. handlerNo: " + handlerNo + ", userName: " + userName + ", client: " + this.myClient.getURL());
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            GitSSHXmlRpcClient.log("getLastSuccessful failed. handlerNo: " + handlerNo + ", userName: " + userName + ", client: " + this.myClient.getURL());
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    private static String adjustNull(String s) {
        return s.charAt(0) == '-' ? null : s.substring(1);
    }

    private static <T> Vector<T> adjustNull(Vector<T> s) {
        return s.size() == 0 ? null : s;
    }

    private static void log(String s) {
        System.err.println(s);
    }
}

