/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.PlatformDetailsTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;

class SummaryTreeNode
extends UpdaterTreeNode {
    private AndroidVersion myVersion;
    private Set<UpdaterTreeNode> myAllChildren;
    private Set<UpdaterTreeNode> myIncludedChildren = Sets.newHashSet();
    private UpdaterTreeNode myPrimaryChild;
    private final String myVersionName;

    public static SummaryTreeNode createNode(AndroidVersion version, Set<UpdaterTreeNode> children, String versionName) {
        HashSet includedChildren = Sets.newHashSet();
        UpdaterTreeNode primaryChild = null;
        for (UpdaterTreeNode child : children) {
            if (child.includeInSummary()) {
                includedChildren.add(child);
            }
            if (!child.isPrimary()) continue;
            primaryChild = child;
        }
        if (!includedChildren.isEmpty()) {
            return new SummaryTreeNode(version, children, includedChildren, primaryChild, versionName);
        }
        return null;
    }

    protected SummaryTreeNode(AndroidVersion version, Set<UpdaterTreeNode> children, Set<UpdaterTreeNode> includedChildren, UpdaterTreeNode primaryChild, String versionName) {
        this.myVersion = version;
        this.myAllChildren = children;
        this.myIncludedChildren = includedChildren;
        this.myPrimaryChild = primaryChild;
        this.myVersionName = versionName;
    }

    @Override
    public NodeStateHolder.SelectedState getInitialState() {
        boolean hasNeedsUpdate = false;
        for (UpdaterTreeNode summaryNode : this.myIncludedChildren) {
            if (summaryNode.getInitialState() == NodeStateHolder.SelectedState.NOT_INSTALLED) {
                return NodeStateHolder.SelectedState.NOT_INSTALLED;
            }
            if (summaryNode.getInitialState() != NodeStateHolder.SelectedState.MIXED) continue;
            hasNeedsUpdate = true;
        }
        return hasNeedsUpdate ? NodeStateHolder.SelectedState.MIXED : NodeStateHolder.SelectedState.INSTALLED;
    }

    @Override
    public NodeStateHolder.SelectedState getCurrentState() {
        boolean hasNeedsUpdate = false;
        for (UpdaterTreeNode summaryNode : this.myIncludedChildren) {
            if (summaryNode.getCurrentState() == NodeStateHolder.SelectedState.NOT_INSTALLED) {
                return NodeStateHolder.SelectedState.NOT_INSTALLED;
            }
            if (summaryNode.getCurrentState() != NodeStateHolder.SelectedState.MIXED) continue;
            hasNeedsUpdate = true;
        }
        return hasNeedsUpdate ? NodeStateHolder.SelectedState.MIXED : NodeStateHolder.SelectedState.INSTALLED;
    }

    @Override
    public int compareTo(UpdaterTreeNode o) {
        if (!(o instanceof SummaryTreeNode)) {
            return super.compareTo(o);
        }
        return this.myVersion.compareTo(((SummaryTreeNode)o).myVersion);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SummaryTreeNode)) {
            return false;
        }
        return this.myVersion.equals((Object)((SummaryTreeNode)obj).myVersion);
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.getTextRenderer().append(SummaryTreeNode.getDescription(this.myVersion, this.myVersionName));
    }

    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    @Override
    protected void setState(NodeStateHolder.SelectedState state) {
        boolean hasOrigNotInstalled = false;
        for (UpdaterTreeNode summaryTreeNode : this.myIncludedChildren) {
            if (summaryTreeNode.getInitialState() != NodeStateHolder.SelectedState.NOT_INSTALLED) continue;
            hasOrigNotInstalled = true;
        }
        for (UpdaterTreeNode child : this.myAllChildren) {
            child.resetState();
        }
        if (state == NodeStateHolder.SelectedState.NOT_INSTALLED && !hasOrigNotInstalled) {
            for (UpdaterTreeNode child : this.myAllChildren) {
                child.setState(NodeStateHolder.SelectedState.NOT_INSTALLED);
            }
        }
        if (state == NodeStateHolder.SelectedState.INSTALLED) {
            for (UpdaterTreeNode child : this.myIncludedChildren) {
                child.setState(NodeStateHolder.SelectedState.INSTALLED);
            }
        }
    }

    @Override
    protected boolean canHaveMixedState() {
        for (UpdaterTreeNode child : this.myIncludedChildren) {
            if (!child.canHaveMixedState()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStatusString() {
        boolean foundSources = false;
        boolean foundPlatform = false;
        boolean foundUpdate = false;
        for (UpdaterTreeNode child : this.myAllChildren) {
            if (child.getInitialState() == NodeStateHolder.SelectedState.NOT_INSTALLED) continue;
            PkgType type = ((PlatformDetailsTreeNode)child).getItemDesc().getType();
            if (type == PkgType.PKG_SOURCE) {
                foundSources = true;
            } else if (type == PkgType.PKG_PLATFORM) {
                foundPlatform = true;
            }
            if (child.getInitialState() != NodeStateHolder.SelectedState.MIXED) continue;
            foundUpdate = true;
        }
        if (foundUpdate) {
            return "Update available";
        }
        if (foundPlatform && foundSources) {
            return "Installed";
        }
        if (foundPlatform || foundSources) {
            return "Partially installed";
        }
        return "Not installed";
    }

    public UpdaterTreeNode getPrimaryChild() {
        return this.myPrimaryChild;
    }

    public static String getDescription(AndroidVersion version, String versionName) {
        StringBuilder result = new StringBuilder();
        result.append("Android ");
        if (version.isPreview()) {
            result.append(version.getCodename());
            result.append(" Preview");
        } else {
            if (versionName == null) {
                result.append(SdkVersionInfo.getVersionString((int)version.getApiLevel()));
            } else {
                result.append(versionName);
            }
            String codeName = version.getCodename();
            if (codeName != null) {
                result.append(" (");
                result.append(codeName);
                result.append(")");
            }
        }
        return result.toString();
    }
}

