/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPlatformPkgInfo;
import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePlatformPkgInfo;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PlatformDetailsTreeNode
extends UpdaterTreeNode {
    private NodeStateHolder myStateHolder;
    private boolean myIncludePreview;
    private final ChangeListener myChangeListener;

    public PlatformDetailsTreeNode(NodeStateHolder state, boolean includePreview, ChangeListener changeListener) {
        this.myStateHolder = state;
        this.myIncludePreview = includePreview;
        this.myStateHolder.setState(this.getInitialState());
        this.myChangeListener = changeListener;
    }

    @Override
    public NodeStateHolder.SelectedState getInitialState() {
        return this.myStateHolder.getPkg().hasRemote(this.myIncludePreview) && this.myStateHolder.getPkg().hasLocal() ? NodeStateHolder.SelectedState.MIXED : (this.myStateHolder.getPkg().hasLocal() ? NodeStateHolder.SelectedState.INSTALLED : NodeStateHolder.SelectedState.NOT_INSTALLED);
    }

    @Override
    public NodeStateHolder.SelectedState getCurrentState() {
        return this.myStateHolder.getState();
    }

    @Override
    public int compareTo(UpdaterTreeNode o) {
        if (!(o instanceof PlatformDetailsTreeNode)) {
            return this.toString().compareTo(o.toString());
        }
        return this.myStateHolder.getPkg().compareTo(((PlatformDetailsTreeNode)o).myStateHolder.getPkg());
    }

    @Override
    protected void setState(NodeStateHolder.SelectedState state) {
        this.myStateHolder.setState(state);
        if (this.myChangeListener != null) {
            this.myChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlatformDetailsTreeNode)) {
            return false;
        }
        return this.myStateHolder.getPkg().equals(((PlatformDetailsTreeNode)obj).myStateHolder.getPkg());
    }

    @Override
    public boolean includeInSummary() {
        return this.myStateHolder.getPkg().getPkgDesc(true).getType() == PkgType.PKG_SOURCE || this.myStateHolder.getPkg().getPkgDesc(true).getType() == PkgType.PKG_PLATFORM;
    }

    @Override
    public boolean isPrimary() {
        return this.myStateHolder.getPkg().getPkgDesc(true).getType() == PkgType.PKG_PLATFORM;
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String result;
        SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        UpdatablePkgInfo p = this.myStateHolder.getPkg();
        if (p.getPkgDesc(true).getType() == PkgType.PKG_PLATFORM) {
            String versionName = p.hasLocal() ? ((LocalPlatformPkgInfo)p.getLocalInfo()).getAndroidTarget().getVersionName() : ((RemotePlatformPkgInfo)p.getRemote(this.myIncludePreview)).getVersionName();
            result = String.format("Android %s Platform", versionName);
            if (p.getPkgDesc(this.myIncludePreview).isObsolete()) {
                result = result + " (Obsolete)";
            }
        } else {
            result = p.getPkgDesc(this.myIncludePreview).getListDescription();
        }
        renderer.getTextRenderer().append(result, attributes);
    }

    public UpdatablePkgInfo getItem() {
        return this.myStateHolder.getPkg();
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.myStateHolder.getPkg().hasRemote(this.myIncludePreview) && this.myStateHolder.getPkg().hasLocal();
    }

    @Override
    public String getStatusString() {
        if (this.getInitialState() == NodeStateHolder.SelectedState.NOT_INSTALLED) {
            return "Not installed";
        }
        if (this.getInitialState() == NodeStateHolder.SelectedState.MIXED) {
            return "Update Available: " + this.myStateHolder.getPkg().getRemote(this.myIncludePreview).getRevision();
        }
        return "Installed";
    }

    public IPkgDesc getItemDesc() {
        return this.getItem().getPkgDesc(this.myIncludePreview);
    }
}

