/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.SummaryTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

class ParentTreeNode
extends UpdaterTreeNode {
    private AndroidVersion myVersion;
    private final String myVersionName;

    public ParentTreeNode(AndroidVersion version, String versionName) {
        this.myVersion = version;
        this.myVersionName = versionName;
    }

    @Override
    public NodeStateHolder.SelectedState getInitialState() {
        boolean hasInstalled = false;
        boolean hasNotInstalled = false;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            if (child.getInitialState() == NodeStateHolder.SelectedState.MIXED) {
                return NodeStateHolder.SelectedState.MIXED;
            }
            if (child.getInitialState() == NodeStateHolder.SelectedState.INSTALLED) {
                hasInstalled = true;
                continue;
            }
            hasNotInstalled = true;
        }
        return hasInstalled ? (hasNotInstalled ? NodeStateHolder.SelectedState.MIXED : NodeStateHolder.SelectedState.INSTALLED) : NodeStateHolder.SelectedState.NOT_INSTALLED;
    }

    @Override
    public NodeStateHolder.SelectedState getCurrentState() {
        boolean foundInstalled = false;
        boolean foundNotInstalled = false;
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            if (child.getCurrentState() != NodeStateHolder.SelectedState.INSTALLED) {
                foundNotInstalled = true;
            }
            if (child.getCurrentState() == NodeStateHolder.SelectedState.NOT_INSTALLED) continue;
            foundInstalled = true;
        }
        if (foundInstalled && foundNotInstalled) {
            return NodeStateHolder.SelectedState.MIXED;
        }
        if (foundInstalled) {
            return NodeStateHolder.SelectedState.INSTALLED;
        }
        return NodeStateHolder.SelectedState.NOT_INSTALLED;
    }

    @Override
    public int compareTo(UpdaterTreeNode o) {
        if (!(o instanceof ParentTreeNode)) {
            return super.compareTo(o);
        }
        return this.myVersion.compareTo(((ParentTreeNode)o).myVersion);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParentTreeNode)) {
            return false;
        }
        if (this.myVersion != null) {
            return this.myVersion.equals((Object)((ParentTreeNode)obj).myVersion);
        }
        return this.getStatusString().equals(((ParentTreeNode)obj).getStatusString());
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.getTextRenderer().append(SummaryTreeNode.getDescription(this.myVersion, this.myVersionName), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    @Override
    protected void setState(NodeStateHolder.SelectedState state) {
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            UpdaterTreeNode child = (UpdaterTreeNode)children.nextElement();
            child.setState(state);
        }
    }
}

