/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.tools.idea.sdk.remote.UpdatablePkgInfo;
import com.android.tools.idea.updater.configure.NodeStateHolder;
import com.android.tools.idea.updater.configure.PlatformDetailsTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import java.util.Set;
import javax.swing.JTree;

class BuildToolsSummaryTreeNode
extends UpdaterTreeNode {
    PlatformDetailsTreeNode myMaxVersionNode;
    Set<UpdaterTreeNode> myBuildToolsNodes;
    boolean myIncludePreview;

    public BuildToolsSummaryTreeNode(Set<UpdaterTreeNode> buildToolsNodes, boolean includePreview) {
        this.myBuildToolsNodes = buildToolsNodes;
        for (UpdaterTreeNode node : this.myBuildToolsNodes) {
            if (this.myMaxVersionNode != null && node.compareTo(this.myMaxVersionNode) <= 0) continue;
            this.myMaxVersionNode = (PlatformDetailsTreeNode)node;
        }
        this.myIncludePreview = includePreview;
    }

    @Override
    public NodeStateHolder.SelectedState getInitialState() {
        if (this.myMaxVersionNode == null) {
            return NodeStateHolder.SelectedState.NOT_INSTALLED;
        }
        if (this.myMaxVersionNode.getInitialState() == NodeStateHolder.SelectedState.INSTALLED) {
            return NodeStateHolder.SelectedState.INSTALLED;
        }
        for (UpdaterTreeNode node : this.myBuildToolsNodes) {
            if (node.getInitialState() == NodeStateHolder.SelectedState.NOT_INSTALLED) continue;
            return NodeStateHolder.SelectedState.MIXED;
        }
        return NodeStateHolder.SelectedState.NOT_INSTALLED;
    }

    @Override
    public NodeStateHolder.SelectedState getCurrentState() {
        if (this.myMaxVersionNode == null) {
            return NodeStateHolder.SelectedState.NOT_INSTALLED;
        }
        if (this.myMaxVersionNode.getCurrentState() == NodeStateHolder.SelectedState.INSTALLED) {
            return NodeStateHolder.SelectedState.INSTALLED;
        }
        for (UpdaterTreeNode node : this.myBuildToolsNodes) {
            if (node.getCurrentState() == NodeStateHolder.SelectedState.NOT_INSTALLED) continue;
            return NodeStateHolder.SelectedState.MIXED;
        }
        return NodeStateHolder.SelectedState.NOT_INSTALLED;
    }

    @Override
    protected boolean canHaveMixedState() {
        return this.getInitialState() == NodeStateHolder.SelectedState.MIXED;
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.getTextRenderer().append("Android SDK Build Tools");
    }

    @Override
    public String getStatusString() {
        String revision;
        if (this.getInitialState() == NodeStateHolder.SelectedState.INSTALLED) {
            return "Installed";
        }
        if (this.getInitialState() == NodeStateHolder.SelectedState.NOT_INSTALLED) {
            return "Not Installed";
        }
        UpdatablePkgInfo p = this.myMaxVersionNode.getItem();
        if (p.hasRemote(this.myIncludePreview)) {
            revision = p.getRemote(this.myIncludePreview).getPkgDesc().getPreciseRevision().toString();
        } else {
            assert (false);
            revision = p.getLocalInfo().getDesc().getPreciseRevision().toString();
        }
        return "Update Available: " + revision;
    }

    @Override
    protected void setState(NodeStateHolder.SelectedState state) {
        if (state == NodeStateHolder.SelectedState.NOT_INSTALLED) {
            for (UpdaterTreeNode node : this.myBuildToolsNodes) {
                node.setState(NodeStateHolder.SelectedState.NOT_INSTALLED);
            }
        } else {
            for (UpdaterTreeNode node : this.myBuildToolsNodes) {
                node.resetState();
            }
            if (state == NodeStateHolder.SelectedState.INSTALLED) {
                this.myMaxVersionNode.setState(NodeStateHolder.SelectedState.INSTALLED);
            }
        }
    }
}

